/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Set;
import javax.management.ObjectName;
import org.apache.geode.cache.Cache;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.GatewaySenderMXBean;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class StatusGatewaySenderCommand
extends SingleGfshCommand {
    @CliCommand(value={"status gateway-sender"}, help="Display the status of a Gateway Sender.")
    @CliMetaData(relatedTopic={"WAN"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public ResultModel statusGatewaySender(@CliOption(key={"id"}, mandatory=true, optionContext="geode.converter.gateway.senderid:disable-string-converter", help="ID of the Gateway Sender.") String senderId, @CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Group(s) of Gateway Senders for which to display status.") String[] onGroup, @CliOption(key={"member", "members"}, optionContext="geode.converter.member.idOrName:disable-string-converter", help="Name/Id of the Gateway Sender for which to display status.") String[] onMember) {
        if (senderId != null) {
            senderId = senderId.trim();
        }
        Cache cache = this.getCache();
        SystemManagementService service = (SystemManagementService)this.getManagementService();
        ResultModel crd = new ResultModel();
        Set<DistributedMember> dsMembers = this.findMembers(onGroup, onMember);
        if (dsMembers.isEmpty()) {
            return ResultModel.createError("No Members Found");
        }
        TabularResultModel availableSenderData = crd.addTable("Available GatewaySender Section");
        TabularResultModel notAvailableSenderData = crd.addTable("Not Available GatewaySender Section");
        for (DistributedMember member : dsMembers) {
            GatewaySenderMXBean bean;
            if (cache.getDistributedSystem().getDistributedMember().getId().equals(member.getId())) {
                bean = service.getLocalGatewaySenderMXBean(senderId);
            } else {
                ObjectName objectName = service.getGatewaySenderMBeanName(member, senderId);
                bean = (GatewaySenderMXBean)service.getMBeanProxy(objectName, GatewaySenderMXBean.class);
            }
            if (bean != null) {
                this.buildSenderStatus(member.getId(), bean, availableSenderData);
                continue;
            }
            this.buildSenderStatus(member.getId(), bean, notAvailableSenderData);
        }
        return crd;
    }

    private TabularResultModel buildSenderStatus(String memberId, GatewaySenderMXBean bean, TabularResultModel resultData) {
        resultData.accumulate("Member", memberId);
        if (bean != null) {
            resultData.accumulate("Type", bean.isParallel() ? "Parallel" : "Serial");
            if (!bean.isParallel()) {
                resultData.accumulate("Runtime Policy", bean.isPrimary() ? "Primary" : "Secondary");
            }
            if (bean.isRunning()) {
                if (bean.isPaused()) {
                    resultData.accumulate("Status", "Paused");
                } else {
                    resultData.accumulate("Status", "Running");
                }
            } else {
                resultData.accumulate("Status", "Not Running");
            }
        } else {
            resultData.accumulate("Error", "GatewaySender is not available");
        }
        return resultData;
    }
}

