/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Properties;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.admin.SSLConfig;
import org.apache.geode.internal.net.SSLConfigurationFactory;
import org.apache.geode.internal.security.SecurableCommunicationChannel;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.internal.JmxManagerLocatorRequest;
import org.apache.geode.management.internal.JmxManagerLocatorResponse;
import org.apache.geode.management.internal.SSLUtil;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.commands.OfflineGfshCommand;
import org.apache.geode.management.internal.cli.commands.UserInputProperty;
import org.apache.geode.management.internal.cli.domain.ConnectToLocatorResult;
import org.apache.geode.management.internal.cli.result.model.InfoResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.cli.shell.JmxOperationInvoker;
import org.apache.geode.management.internal.cli.shell.OperationInvoker;
import org.apache.geode.management.internal.cli.util.ConnectionEndpoint;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.apache.geode.management.internal.web.shell.HttpOperationInvoker;
import org.apache.geode.security.AuthenticationFailedException;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ConnectCommand
extends OfflineGfshCommand {
    static final int CONNECT_LOCATOR_TIMEOUT_MS = 60000;
    private static final int VERSION_MAJOR = 0;
    private static final int VERSION_MINOR = 1;
    @Immutable
    private static final UserInputProperty[] USER_INPUT_PROPERTIES = new UserInputProperty[]{UserInputProperty.KEYSTORE, UserInputProperty.KEYSTORE_PASSWORD, UserInputProperty.KEYSTORE_TYPE, UserInputProperty.TRUSTSTORE, UserInputProperty.TRUSTSTORE_PASSWORD, UserInputProperty.TRUSTSTORE_TYPE, UserInputProperty.CIPHERS, UserInputProperty.PROTOCOL, UserInputProperty.COMPONENT};

    @CliCommand(value={"connect"}, help="Connect to a jmx-manager either directly or via a Locator. If connecting via a Locator, and a jmx-manager doesn't already exist, the Locator will start one.")
    @CliMetaData(shellOnly=true, relatedTopic={"GFSH", "JMX", "Manager"})
    public ResultModel connect(@CliOption(key={"locator"}, unspecifiedDefaultValue="localhost[10334]", optionContext="__locator__", help="Network address of the Locator in the form: host[port].") ConnectionEndpoint locatorEndPoint, @CliOption(key={"jmx-manager"}, optionContext="__jmx-manager__", help="Network address of the jmx-manager in the form: host[port].") ConnectionEndpoint jmxManagerEndPoint, @CliOption(key={"use-http"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="[Deprecated: inferred by the presence of --url]. Connects to Manager by sending HTTP requests to HTTP service hosting the Management REST API. You must first 'disconnect' in order to reconnect to the Manager via locator or jmx-manager using JMX.") boolean useHttp, @CliOption(key={"url"}, help="Indicates the base URL to the Manager's HTTP service.  For example: 'http://<host>:<port>/gemfire/v1' Default is 'http://localhost:7070/geode-mgmt/v1'") String url, @CliOption(key={"user"}, help="User name to securely connect to the jmx-manager. If the --password parameter is not specified then it will be prompted for.") String userName, @CliOption(key={"password"}, help="Password to securely connect to the jmx-manager.") String password, @CliOption(key={"key-store"}, help="Java keystore file containing this application's certificate and private key. If the --key-store-password parameter is not specified then it will be prompted for.") String keystore, @CliOption(key={"key-store-password"}, help="Password to access the private key from the keystore file specified by --key-store.") String keystorePassword, @CliOption(key={"trust-store"}, help="Java keystore file containing the collection of CA certificates trusted by this application. If the --trust-store-password parameter is not specified then it will be prompted for.") String truststore, @CliOption(key={"trust-store-password"}, help="Password to unlock the keystore file specified by --trust-store") String truststorePassword, @CliOption(key={"ciphers"}, help="SSL/TLS ciphers used when encrypting the connection. The default is \"any\".") String sslCiphers, @CliOption(key={"protocols"}, help="SSL/TLS protocol versions to enable when encrypting the connection. The default is \"any\".") String sslProtocols, @CliOption(key={"security-properties-file"}, optionContext="geode.converter.file", help="The gfsecurity.properties file for configuring gfsh to connect to the Locator/Manager. The file's path can be absolute or relative to gfsh directory.") File gfSecurityPropertiesFile, @CliOption(key={"use-ssl"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Whether to use SSL for communication with Locator and/or JMX Manager. If set to \"true\", \"gfsecurity.properties\" will also be read. SSL Options take precedence over the properties file. If none are specified, defaults will be used. The default value for this options is \"false\". This option is only required if JMX is to be used over SSL. For http, the protocol is inferred from the URL.") boolean useSsl, @CliOption(key={"skip-ssl-validation"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="When connecting via HTTP, connects using 1-way SSL validation rather than 2-way SSL validation.") boolean skipSslValidation) {
        Properties gfProperties;
        ResultModel result = new ResultModel();
        Gfsh gfsh = this.getGfsh();
        if (gfsh != null && gfsh.isConnectedAndReady()) {
            return ResultModel.createInfo("Already connected to: " + this.getGfsh().getOperationInvoker().toString());
        }
        if (StringUtils.startsWith((CharSequence)url, (CharSequence)"https")) {
            useSsl = true;
        }
        if (ConnectCommand.containsSSLConfig(gfProperties = this.resolveSslProperties(gfsh, useSsl, null, gfSecurityPropertiesFile, keystore, keystorePassword, null, truststore, truststorePassword, null, sslCiphers, sslProtocols, null)) || ConnectCommand.containsLegacySSLConfig(gfProperties)) {
            useSsl = true;
        }
        if (userName != null) {
            gfProperties.setProperty("security-username", userName);
            if (password == null) {
                password = UserInputProperty.PASSWORD.promptForAcceptableValue(gfsh);
            }
            gfProperties.setProperty(UserInputProperty.PASSWORD.getKey(), password);
        }
        result = StringUtils.isNotEmpty((CharSequence)url) ? this.httpConnect(gfProperties, url, skipSslValidation) : this.jmxConnect(gfProperties, useSsl, jmxManagerEndPoint, locatorEndPoint, false);
        OperationInvoker invoker = gfsh.getOperationInvoker();
        if (invoker == null || !invoker.isConnected()) {
            return result;
        }
        String remoteVersion = null;
        String gfshVersion = gfsh.getVersion();
        try {
            remoteVersion = invoker.getRemoteVersion();
            int minorVersion = Integer.parseInt(ConnectCommand.versionComponent(remoteVersion, 1));
            if (ConnectCommand.versionComponent(remoteVersion, 0).equals("1") && minorVersion >= 10 || ConnectCommand.versionComponent(remoteVersion, 0).equals("9") && minorVersion >= 9) {
                InfoResultModel versionInfo = result.addInfo("versionInfo");
                versionInfo.addLine("You are connected to a cluster of version: " + remoteVersion);
                return result;
            }
        }
        catch (Exception ex) {
            gfsh.logInfo("failed to get the the remote version.", ex);
        }
        invoker.stop();
        if (remoteVersion == null) {
            return ResultModel.createError(String.format("Cannot use a %s gfsh client to connect to this cluster.", gfshVersion));
        }
        return ResultModel.createError(String.format("Cannot use a %s gfsh client to connect to a %s cluster.", gfshVersion, remoteVersion));
    }

    private static String versionComponent(String version, int component) {
        String[] versionComponents = StringUtils.split((String)version, (char)'.');
        return versionComponents.length >= component + 1 ? versionComponents[component] : "";
    }

    Properties resolveSslProperties(Gfsh gfsh, boolean useSsl, File gfPropertiesFile, File gfSecurityPropertiesFile, String ... sslOptionValues) {
        Properties gfProperties = this.loadProperties(gfPropertiesFile, gfSecurityPropertiesFile);
        if (ConnectCommand.containsLegacySSLConfig(gfProperties)) {
            return gfProperties;
        }
        if (!(useSsl || ConnectCommand.containsSSLConfig(gfProperties) || this.isSslImpliedBySslOptions(sslOptionValues))) {
            return gfProperties;
        }
        for (int i = 0; i < USER_INPUT_PROPERTIES.length; ++i) {
            UserInputProperty userInputProperty = USER_INPUT_PROPERTIES[i];
            String sslOptionValue = null;
            if (sslOptionValues != null && sslOptionValues.length > i) {
                sslOptionValue = sslOptionValues[i];
            }
            String sslConfigValue = gfProperties.getProperty(userInputProperty.getKey());
            if (sslOptionValue != null) {
                gfProperties.setProperty(userInputProperty.getKey(), sslOptionValue);
                continue;
            }
            if (sslConfigValue != null) continue;
            gfProperties.setProperty(userInputProperty.getKey(), userInputProperty.promptForAcceptableValue(gfsh));
        }
        return gfProperties;
    }

    boolean isSslImpliedBySslOptions(String ... sslOptions) {
        return sslOptions != null && Arrays.stream(sslOptions).anyMatch(Objects::nonNull);
    }

    static boolean containsLegacySSLConfig(Properties properties) {
        return properties.stringPropertyNames().stream().anyMatch(key -> key.startsWith("cluster-ssl") || key.startsWith("jmx-manager-ssl-") || key.startsWith("http-service-ssl-"));
    }

    private static boolean containsSSLConfig(Properties properties) {
        return properties.stringPropertyNames().stream().anyMatch(key -> key.startsWith("ssl-"));
    }

    ResultModel httpConnect(Properties gfProperties, String url, boolean skipSslVerification) {
        Gfsh gfsh = this.getGfsh();
        try {
            SSLConfig sslConfig = SSLConfigurationFactory.getSSLConfigForComponent((Properties)gfProperties, (SecurableCommunicationChannel)SecurableCommunicationChannel.WEB);
            if (sslConfig.isEnabled()) {
                this.configureHttpsURLConnection(sslConfig, skipSslVerification);
                if (url.startsWith("http:")) {
                    url = url.replace("http:", "https:");
                }
            }
            HttpOperationInvoker operationInvoker = new HttpOperationInvoker(gfsh, url, gfProperties);
            gfsh.setOperationInvoker(operationInvoker);
            LogWrapper.getInstance().info(CliStrings.format((String)"Successfully connected to: {0}", (Object)operationInvoker.toString()));
            return ResultModel.createInfo(CliStrings.format((String)"Successfully connected to: {0}", (Object)operationInvoker.toString()));
        }
        catch (SecurityException | AuthenticationFailedException e) {
            if (gfProperties.containsKey("security-username")) {
                return this.handleException((Exception)e);
            }
            gfProperties.setProperty(UserInputProperty.USERNAME.getKey(), UserInputProperty.USERNAME.promptForAcceptableValue(gfsh));
            gfProperties.setProperty(UserInputProperty.PASSWORD.getKey(), UserInputProperty.PASSWORD.promptForAcceptableValue(gfsh));
            return this.httpConnect(gfProperties, url, skipSslVerification);
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    ResultModel jmxConnect(Properties gfProperties, boolean useSsl, ConnectionEndpoint memberRmiHostPort, ConnectionEndpoint locatorTcpHostPort, boolean retry) {
        ConnectionEndpoint jmxHostPortToConnect = null;
        Gfsh gfsh = this.getGfsh();
        try {
            if (memberRmiHostPort != null) {
                jmxHostPortToConnect = memberRmiHostPort;
            } else {
                if (useSsl) {
                    gfsh.logToFile("use-ssl is set to true. Connecting to Locator via SSL.", null);
                }
                Gfsh.println(CliStrings.format((String)"Connecting to Locator at {0} ..", (Object[])new Object[]{locatorTcpHostPort.toString(false)}));
                ConnectToLocatorResult connectToLocatorResult = ConnectCommand.connectToLocator(locatorTcpHostPort.getHost(), locatorTcpHostPort.getPort(), 60000, gfProperties);
                jmxHostPortToConnect = connectToLocatorResult.getMemberEndpoint();
                if (useSsl && !connectToLocatorResult.isJmxManagerSslEnabled()) {
                    gfsh.logInfo("use-ssl is set to true. But JMX Manager doesn't support SSL, connecting without SSL.", null);
                    useSsl = false;
                }
            }
            if (useSsl) {
                gfsh.logToFile("Connecting to manager via SSL.", null);
            }
            if (!retry) {
                Gfsh.println(CliStrings.format((String)"Connecting to Manager at {0} ..", (Object[])new Object[]{jmxHostPortToConnect.toString(false)}));
            }
            ResultModel result = new ResultModel();
            InfoResultModel infoResultModel = result.addInfo();
            JmxOperationInvoker operationInvoker = new JmxOperationInvoker(jmxHostPortToConnect.getHost(), jmxHostPortToConnect.getPort(), gfProperties);
            gfsh.setOperationInvoker(operationInvoker);
            infoResultModel.addLine(CliStrings.format((String)"Successfully connected to: {0}", (Object)jmxHostPortToConnect.toString(false)));
            LogWrapper.getInstance().info(CliStrings.format((String)"Successfully connected to: {0}", (Object)jmxHostPortToConnect.toString(false)));
            return result;
        }
        catch (SecurityException | AuthenticationFailedException e) {
            if (gfProperties.containsKey("security-username")) {
                return this.handleException((Exception)e, jmxHostPortToConnect);
            }
            gfProperties.setProperty(UserInputProperty.USERNAME.getKey(), UserInputProperty.USERNAME.promptForAcceptableValue(gfsh));
            gfProperties.setProperty(UserInputProperty.PASSWORD.getKey(), UserInputProperty.PASSWORD.promptForAcceptableValue(gfsh));
            return this.jmxConnect(gfProperties, useSsl, jmxHostPortToConnect, null, true);
        }
        catch (UnknownHostException e) {
            return this.handleException((Exception)e, "JMX manager can't be reached. Hostname or IP address could not be found.");
        }
        catch (Exception e) {
            return this.handleException(e, jmxHostPortToConnect);
        }
    }

    public static ConnectToLocatorResult connectToLocator(String host, int port, int timeout, Properties props) throws IOException, ClassNotFoundException {
        JmxManagerLocatorResponse locatorResponse = JmxManagerLocatorRequest.send((String)host, (int)port, (int)timeout, (Properties)props);
        if (StringUtils.isBlank((CharSequence)locatorResponse.getHost()) || locatorResponse.getPort() == 0) {
            Throwable locatorResponseException = locatorResponse.getException();
            String exceptionMessage = "Locator could not find a JMX Manager";
            if (locatorResponseException != null) {
                String locatorResponseExceptionMessage = locatorResponseException.getMessage();
                locatorResponseExceptionMessage = StringUtils.isNotBlank((CharSequence)locatorResponseExceptionMessage) ? locatorResponseExceptionMessage : locatorResponseException.toString();
                exceptionMessage = "Exception caused JMX Manager startup to fail because: '".concat(locatorResponseExceptionMessage).concat("'");
            }
            throw new IllegalStateException(exceptionMessage, locatorResponseException);
        }
        ConnectionEndpoint memberEndpoint = new ConnectionEndpoint(locatorResponse.getHost(), locatorResponse.getPort());
        String resultMessage = CliStrings.format((String)"Connecting to Manager at {0} ..", (Object)memberEndpoint.toString(false));
        return new ConnectToLocatorResult(memberEndpoint, resultMessage, locatorResponse.isJmxManagerSslEnabled());
    }

    private void configureHttpsURLConnection(SSLConfig sslConfig, boolean skipSslVerification) {
        SSLContext ssl = SSLUtil.createAndConfigureSSLContext((SSLConfig)sslConfig, (boolean)skipSslVerification);
        if (skipSslVerification) {
            HttpsURLConnection.setDefaultHostnameVerifier((s, sslSession) -> true);
        }
        HttpsURLConnection.setDefaultSSLSocketFactory(ssl.getSocketFactory());
    }

    private ResultModel handleException(Exception e) {
        return this.handleException(e, e.getMessage());
    }

    private ResultModel handleException(Exception e, String errorMessage) {
        LogWrapper.getInstance().severe(errorMessage, e);
        return ResultModel.createError(errorMessage);
    }

    private ResultModel handleException(Exception e, ConnectionEndpoint hostPortToConnect) {
        if (hostPortToConnect == null) {
            return this.handleException(e);
        }
        return this.handleException(e, CliStrings.format((String)"Could not connect to : {0}. {1}", (Object[])new Object[]{hostPortToConnect.toString(false), e.getMessage()}));
    }
}

