/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import org.apache.geode.cache.asyncqueue.internal.AsyncEventQueueImpl;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.management.internal.cli.functions.DestroyAsyncEventQueueFunctionArgs;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.functions.CliFunctionResult;

public class DestroyAsyncEventQueueFunction
implements InternalFunction {
    private static final long serialVersionUID = -7754359270344102817L;

    public void execute(FunctionContext context) {
        String memberId = "";
        DestroyAsyncEventQueueFunctionArgs aeqArgs = (DestroyAsyncEventQueueFunctionArgs)context.getArguments();
        String aeqId = aeqArgs.getId();
        memberId = context.getMemberName();
        try {
            AsyncEventQueueImpl aeq = (AsyncEventQueueImpl)context.getCache().getAsyncEventQueue(aeqId);
            if (aeq == null) {
                if (aeqArgs.isIfExists()) {
                    context.getResultSender().lastResult((Object)new CliFunctionResult(memberId, true, String.format("Skipping: Async event queue \"%s\" not found", aeqId)));
                } else {
                    context.getResultSender().lastResult((Object)new CliFunctionResult(memberId, false, String.format("Async event queue \"%s\" not found", aeqId)));
                }
            } else {
                XmlEntity xmlEntity = this.getAEQXmlEntity("id", aeqId);
                aeq.stop();
                aeq.destroy();
                context.getResultSender().lastResult((Object)new CliFunctionResult(memberId, xmlEntity, String.format("Async event queue \"%s\" destroyed", aeqId)));
            }
        }
        catch (Exception e) {
            context.getResultSender().lastResult((Object)new CliFunctionResult(memberId, (Object)e, e.getMessage()));
        }
    }

    XmlEntity getAEQXmlEntity(String key, String value) {
        XmlEntity xmlEntity = new XmlEntity("async-event-queue", key, value);
        return xmlEntity;
    }

    public String getId() {
        return DestroyAsyncEventQueueFunction.class.getName();
    }
}

