/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.converters;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.geode.management.internal.cli.converters.FilePathStringConverter;
import org.apache.geode.management.internal.cli.converters.JarDirPathConverter;
import org.springframework.shell.core.Completion;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.MethodTarget;

public class JarFilesPathConverter
implements Converter<String[]> {
    private FilePathStringConverter delegate = new FilePathStringConverter();

    public void setDelegate(FilePathStringConverter delegate) {
        this.delegate = delegate;
    }

    public boolean supports(Class<?> type, String optionContext) {
        return String[].class.equals(type) && optionContext.contains("geode.converter.jarfiles:disable-string-converter");
    }

    public String[] convertFromText(String value, Class<?> targetType, String optionContext) {
        return value.split(",");
    }

    public boolean getAllPossibleValues(List<Completion> completions, Class<?> targetType, String existingData, String optionContext, MethodTarget target) {
        int comma = existingData.lastIndexOf(44) + 1;
        String otherJars = existingData.substring(0, comma);
        existingData = existingData.substring(comma);
        ArrayList<Completion> allCompletions = new ArrayList<Completion>();
        this.delegate.getAllPossibleValues(allCompletions, targetType, existingData, optionContext, target);
        completions.addAll(allCompletions.stream().map(Completion::getValue).filter(JarFilesPathConverter::isDirOrJar).map(s -> new Completion(otherJars + s)).collect(Collectors.toList()));
        return JarFilesPathConverter.allAreJars(completions);
    }

    private static boolean isDirOrJar(String file) {
        return JarDirPathConverter.isDirWithDirsOrDirWithJars(file) || file.endsWith(".jar");
    }

    private static boolean allAreJars(List<Completion> completions) {
        return completions.stream().allMatch(c -> c.getValue().endsWith(".jar"));
    }
}

