/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.util;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.util.CacheWriterAdapter;

public class ExportLogsCacheWriter
extends CacheWriterAdapter<String, byte[]>
implements Serializable {
    private Path currentFile;
    private boolean isEmpty = true;
    private BufferedOutputStream currentOutputStream;

    public void beforeCreate(EntryEvent<String, byte[]> event) throws CacheWriterException {
        if (this.currentOutputStream == null) {
            throw new IllegalStateException("No outputStream is open.  You must call startFile before sending data.");
        }
        try {
            this.currentOutputStream.write((byte[])event.getNewValue());
            this.isEmpty = false;
        }
        catch (IOException e) {
            throw new CacheWriterException((Throwable)e);
        }
    }

    public void startFile(String memberId) throws IOException {
        if (this.currentFile != null || this.currentOutputStream != null) {
            throw new IllegalStateException("Cannot open more than one file at once");
        }
        this.currentFile = Files.createTempDirectory(memberId, new FileAttribute[0]).resolve(memberId + ".zip");
        this.currentOutputStream = new BufferedOutputStream(new FileOutputStream(this.currentFile.toFile()));
        this.isEmpty = true;
    }

    public Path endFile() {
        Path completedFile = this.currentFile;
        try {
            if (null != this.currentOutputStream) {
                this.currentOutputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.currentOutputStream = null;
        this.currentFile = null;
        if (this.isEmpty) {
            return null;
        }
        return completedFile;
    }
}

