/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.compiler;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.geode.test.compiler.ClassNameExtractor;

public class UncompiledSourceCode {
    public String simpleClassName;
    public String sourceCode;

    private UncompiledSourceCode(String simpleClassName, String sourceCode) {
        this.simpleClassName = simpleClassName;
        this.sourceCode = sourceCode;
    }

    public static UncompiledSourceCode fromSourceCode(String sourceCode) {
        String simpleClassName = new ClassNameExtractor().extractFromSourceCode(sourceCode);
        return new UncompiledSourceCode(simpleClassName, sourceCode);
    }

    public static UncompiledSourceCode fromClassName(String fullyQualifiedClassName) {
        ClassNameWithPackage classNameWithPackage = ClassNameWithPackage.of(fullyQualifiedClassName);
        boolean isPackageSpecified = StringUtils.isNotBlank((String)classNameWithPackage.packageName);
        StringBuilder sourceCode = new StringBuilder();
        if (isPackageSpecified) {
            sourceCode.append(String.format("package %s;", classNameWithPackage.packageName));
            sourceCode.append(SystemUtils.LINE_SEPARATOR);
        }
        sourceCode.append(String.format("public class %s {}", classNameWithPackage.simpleClassName));
        return new UncompiledSourceCode(classNameWithPackage.simpleClassName, sourceCode.toString());
    }

    private static class ClassNameWithPackage {
        String packageName;
        String simpleClassName;

        static ClassNameWithPackage of(String fqClassName) {
            int indexOfLastDot = fqClassName.lastIndexOf(".");
            if (indexOfLastDot == -1) {
                return new ClassNameWithPackage("", fqClassName);
            }
            String specifiedPackage = fqClassName.substring(0, indexOfLastDot);
            String simpleClassName = fqClassName.substring(indexOfLastDot + 1);
            return new ClassNameWithPackage(specifiedPackage, simpleClassName);
        }

        private ClassNameWithPackage(String packageName, String simpleClassName) {
            this.packageName = packageName;
            this.simpleClassName = simpleClassName;
        }
    }
}

