/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.junit.rules.gfsh.internal;

import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import org.apache.commons.lang.SystemUtils;
import org.apache.geode.test.junit.rules.gfsh.internal.OutputLine;
import org.apache.geode.test.junit.rules.gfsh.internal.StreamGobbler;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.FilterComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;

public class ProcessLogger {
    private static final LoggerContext LOGGER_CONTEXT = ProcessLogger.createLoggerContext();
    private final Logger logger;
    private final Queue<OutputLine> outputLines = new ConcurrentLinkedQueue<OutputLine>();

    public ProcessLogger(Process process, String name) {
        this.logger = LOGGER_CONTEXT.getLogger(name);
        StreamGobbler stdOutGobbler = new StreamGobbler(process.getInputStream(), this::consumeInfoMessage);
        StreamGobbler stdErrGobbler = new StreamGobbler(process.getErrorStream(), this::consumeErrorMessage);
        stdOutGobbler.startInNewThread();
        stdErrGobbler.startInNewThread();
    }

    private void consumeInfoMessage(String message) {
        this.logger.info(message);
        this.outputLines.add(OutputLine.fromStdOut(message));
    }

    private void consumeErrorMessage(String message) {
        this.logger.error(message);
        this.outputLines.add(OutputLine.fromStdErr(message));
    }

    private static LoggerContext createLoggerContext() {
        ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
        builder.setStatusLevel(Level.ERROR);
        builder.add((FilterComponentBuilder)builder.newFilter("ThresholdFilter", Filter.Result.ACCEPT, Filter.Result.NEUTRAL).addAttribute("level", Level.DEBUG));
        AppenderComponentBuilder appenderBuilder = (AppenderComponentBuilder)builder.newAppender("Stdout", "CONSOLE").addAttribute("target", (Enum)ConsoleAppender.Target.SYSTEM_OUT);
        appenderBuilder.add((LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", "[%-5level %d{HH:mm:ss.SSS z}] (%c): %msg%n%throwable"));
        appenderBuilder.add((FilterComponentBuilder)builder.newFilter("MarkerFilter", Filter.Result.DENY, Filter.Result.NEUTRAL).addAttribute("marker", "FLOW"));
        builder.add(appenderBuilder);
        builder.add((LoggerComponentBuilder)((LoggerComponentBuilder)builder.newLogger("org.apache.logging.log4j", Level.ERROR).add(builder.newAppenderRef("Stdout"))).addAttribute("additivity", false));
        builder.add((RootLoggerComponentBuilder)builder.newRootLogger(Level.ERROR).add(builder.newAppenderRef("Stdout")));
        return Configurator.initialize((Configuration)((Configuration)builder.build()));
    }

    public List<String> getStdOutLines() {
        return this.getOutputLines(OutputLine.OutputSource.STD_OUT);
    }

    public List<String> getStdErrLines() {
        return this.getOutputLines(OutputLine.OutputSource.STD_ERR);
    }

    public List<String> getOutputLines() {
        return this.outputLines.stream().map(OutputLine::getLine).collect(Collectors.toList());
    }

    public String getOutputText() {
        return this.outputLines.stream().map(OutputLine::getLine).collect(Collectors.joining(SystemUtils.LINE_SEPARATOR));
    }

    private List<String> getOutputLines(OutputLine.OutputSource source) {
        return this.outputLines.stream().filter(line -> line.getSource().equals((Object)source)).map(OutputLine::getLine).collect(Collectors.toList());
    }
}

