/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal;

import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.lucene.LuceneQuery;
import org.apache.geode.cache.lucene.LuceneQueryFactory;
import org.apache.geode.cache.lucene.LuceneQueryProvider;
import org.apache.geode.cache.lucene.internal.LuceneQueryImpl;
import org.apache.geode.cache.lucene.internal.StringQueryProvider;

public class LuceneQueryFactoryImpl
implements LuceneQueryFactory {
    private int limit = 100;
    private int pageSize = 0;
    private Cache cache;

    LuceneQueryFactoryImpl(Cache cache) {
        this.cache = cache;
    }

    @Override
    public LuceneQueryFactory setPageSize(int pageSize) {
        if (pageSize < 0) {
            throw new IllegalArgumentException("Page size is negative: " + pageSize);
        }
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public LuceneQueryFactory setLimit(int limit) {
        if (limit <= 0) {
            throw new IllegalArgumentException("Limit is <= 0: " + limit);
        }
        this.limit = limit;
        return this;
    }

    @Override
    public <K, V> LuceneQuery<K, V> create(String indexName, String regionName, String queryString, String defaultField) {
        return this.create(indexName, regionName, new StringQueryProvider(queryString, defaultField));
    }

    @Override
    public <K, V> LuceneQuery<K, V> create(String indexName, String regionName, LuceneQueryProvider provider) {
        Region region = this.cache.getRegion(regionName);
        if (region == null) {
            throw new IllegalArgumentException("Region not found: " + regionName);
        }
        LuceneQueryImpl luceneQuery = new LuceneQueryImpl(indexName, region, provider, this.limit, this.pageSize);
        return luceneQuery;
    }
}

