/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.cli;

import org.apache.geode.cache.lucene.internal.cli.LuceneCommandBase;
import org.apache.geode.cache.lucene.internal.cli.LuceneIndexInfo;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class LuceneDescribeIndexCommand
extends LuceneCommandBase {
    @CliCommand(value={"describe lucene index"}, help="Display the description of lucene indexes created for all members.")
    @CliMetaData(relatedTopic={"Region", "Data"})
    public ResultModel describeIndex(@CliOption(key={"name"}, mandatory=true, help="Name of the lucene index to describe.") String indexName, @CliOption(key={"region"}, mandatory=true, optionContext="geode.converter.region.path:disable-string-converter", help="Name/Path of the region defining the lucene index to be described.") String regionPath) throws Exception {
        this.authorize(ResourcePermission.Resource.CLUSTER, ResourcePermission.Operation.READ, "LUCENE");
        LuceneIndexInfo indexInfo = new LuceneIndexInfo(indexName, regionPath);
        return this.toTabularResult(this.getIndexDetails(indexInfo), true);
    }

    @Override
    @CliAvailabilityIndicator(value={"describe lucene index"})
    public boolean indexCommandsAvailable() {
        return super.indexCommandsAvailable();
    }
}

