/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class CreateLuceneCommandParametersValidator {
    public static void validateRegionName(String name) {
        CreateLuceneCommandParametersValidator.validateNameNotEmptyOrNull(name);
        String msg = "Region names may only be alphanumeric, must not begin with double-underscores, but can contain hyphens, underscores, or forward slashes: ";
        Matcher matcher = Pattern.compile("[aA-zZ0-9-_./]+").matcher(name);
        if (name.startsWith("__") || name.startsWith("/__") || !matcher.matches()) {
            throw new IllegalArgumentException(msg + name);
        }
    }

    public static void validateLuceneIndexName(String name) {
        CreateLuceneCommandParametersValidator.validateNameNotEmptyOrNull(name);
        String msg = "Index names may only be alphanumeric, must not begin with double-underscores, but can contain hyphens or underscores: ";
        Matcher matcher = Pattern.compile("[aA-zZ0-9-_.]+").matcher(name);
        if (name.startsWith("__") || !matcher.matches()) {
            throw new IllegalArgumentException(msg + name);
        }
    }

    private static void validateNameNotEmptyOrNull(String nameProvided) {
        if (nameProvided == null) {
            throw new IllegalArgumentException(LocalizedStrings.LocalRegion_NAME_CANNOT_BE_NULL.toLocalizedString());
        }
        if (nameProvided.isEmpty()) {
            throw new IllegalArgumentException(LocalizedStrings.LocalRegion_NAME_CANNOT_BE_EMPTY.toLocalizedString());
        }
    }
}

