/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.cache.lucene.internal.cli.LuceneDestroyIndexInfo;
import org.apache.geode.cache.lucene.internal.cli.LuceneFunctionSerializable;
import org.apache.geode.cache.lucene.internal.cli.LuceneIndexDetails;
import org.apache.geode.cache.lucene.internal.cli.LuceneIndexInfo;
import org.apache.geode.cache.lucene.internal.cli.LuceneQueryInfo;
import org.apache.geode.cache.lucene.internal.cli.LuceneSearchResults;
import org.apache.geode.cache.lucene.internal.cli.functions.LuceneCreateIndexFunction;
import org.apache.geode.cache.lucene.internal.cli.functions.LuceneDescribeIndexFunction;
import org.apache.geode.cache.lucene.internal.cli.functions.LuceneDestroyIndexFunction;
import org.apache.geode.cache.lucene.internal.cli.functions.LuceneListIndexFunction;
import org.apache.geode.cache.lucene.internal.cli.functions.LuceneSearchIndexFunction;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalClusterConfigurationService;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.exceptions.UserErrorException;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.CommandResultException;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.ResultData;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class LuceneIndexCommands
extends InternalGfshCommand {
    private static final LuceneCreateIndexFunction createIndexFunction = new LuceneCreateIndexFunction();
    private static final LuceneDescribeIndexFunction describeIndexFunction = new LuceneDescribeIndexFunction();
    private static final LuceneSearchIndexFunction searchIndexFunction = new LuceneSearchIndexFunction();
    private static final LuceneDestroyIndexFunction destroyIndexFunction = new LuceneDestroyIndexFunction();
    private List<LuceneSearchResults> searchResults = null;

    @CliCommand(value={"list lucene indexes"}, help="Display the list of lucene indexes created for all members.")
    @CliMetaData(relatedTopic={"Region", "Data"})
    public Result listIndex(@CliOption(key={"with-stats"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Display lucene index stats") boolean stats) {
        this.authorize(ResourcePermission.Resource.CLUSTER, ResourcePermission.Operation.READ, "LUCENE");
        return this.toTabularResult(this.getIndexListing(), stats);
    }

    protected List<LuceneIndexDetails> getIndexListing() {
        Execution functionExecutor = this.getMembersFunctionExecutor(this.getAllMembers());
        if (functionExecutor instanceof AbstractExecution) {
            ((AbstractExecution)functionExecutor).setIgnoreDepartedMembers(true);
        }
        ResultCollector resultsCollector = functionExecutor.execute((Function)new LuceneListIndexFunction());
        List results = (List)resultsCollector.getResult();
        List<LuceneIndexDetails> sortedResults = results.stream().flatMap(Collection::stream).sorted().collect(Collectors.toList());
        LinkedHashSet<LuceneIndexDetails> uniqResults = new LinkedHashSet<LuceneIndexDetails>();
        uniqResults.addAll(sortedResults);
        sortedResults.clear();
        sortedResults.addAll(uniqResults);
        return sortedResults;
    }

    protected Result toTabularResult(List<LuceneIndexDetails> indexDetailsList, boolean stats) {
        if (!indexDetailsList.isEmpty()) {
            TabularResultData indexData = ResultBuilder.createTabularResultData();
            for (LuceneIndexDetails indexDetails : indexDetailsList) {
                indexData.accumulate("Index Name", (Object)indexDetails.getIndexName());
                indexData.accumulate("Region Path", (Object)indexDetails.getRegionPath());
                indexData.accumulate("Server Name", (Object)indexDetails.getServerName());
                indexData.accumulate("Indexed Fields", (Object)indexDetails.getSearchableFieldNamesString());
                indexData.accumulate("Field Analyzer", (Object)indexDetails.getFieldAnalyzersString());
                indexData.accumulate("Serializer", (Object)indexDetails.getSerializerString());
                indexData.accumulate("Status", (Object)(indexDetails.getInitialized() ? "Initialized" : "Defined"));
                if (!stats) continue;
                if (!indexDetails.getInitialized()) {
                    indexData.accumulate("Query Executions", (Object)"NA");
                    indexData.accumulate("Updates", (Object)"NA");
                    indexData.accumulate("Commits", (Object)"NA");
                    indexData.accumulate("Documents", (Object)"NA");
                    continue;
                }
                indexData.accumulate("Query Executions", (Object)indexDetails.getIndexStats().get("queryExecutions"));
                indexData.accumulate("Updates", (Object)indexDetails.getIndexStats().get("updates"));
                indexData.accumulate("Commits", (Object)indexDetails.getIndexStats().get("commits"));
                indexData.accumulate("Documents", (Object)indexDetails.getIndexStats().get("documents"));
            }
            return ResultBuilder.buildResult((ResultData)indexData);
        }
        return ResultBuilder.createInfoResult((String)"No lucene indexes found");
    }

    @CliCommand(value={"create lucene index"}, help="Create a lucene index that can be used to execute queries.")
    @CliMetaData(relatedTopic={"Region", "Data"})
    public Result createIndex(@CliOption(key={"name"}, mandatory=true, help="Name of the lucene index to create.") String indexName, @CliOption(key={"region"}, mandatory=true, optionContext="geode.converter.region.path:disable-string-converter", help="Name/Path of the region on which to create the lucene index.") String regionPath, @CliOption(key={"field"}, mandatory=true, help="Fields on the region values which are stored in the lucene index.\nUse __REGION_VALUE_FIELD if the entire region value should be indexed.\n__REGION_VALUE_FIELD is valid only if the region values are strings or numbers.") String[] fields, @CliOption(key={"analyzer"}, help="Type of the analyzer for each field.\nUse the case sensitive keyword DEFAULT or leave an analyzer blank to use the default standard analyzer.") String[] analyzers, @CliOption(key={"serializer"}, help="Fully qualified class name of the LuceneSerializer to use with this index.\n") String serializer) throws CommandResultException {
        this.authorize(ResourcePermission.Resource.CLUSTER, ResourcePermission.Operation.MANAGE, "LUCENE");
        InternalCache cache = (InternalCache)this.getCache();
        String[] trimmedFields = (String[])Arrays.stream(fields).map(String::trim).toArray(String[]::new);
        LuceneIndexInfo indexInfo = new LuceneIndexInfo(indexName, regionPath, trimmedFields, analyzers, serializer);
        ResultCollector<?, ?> rc = this.executeFunctionOnAllMembers((Function)createIndexFunction, indexInfo);
        List funcResults = (List)rc.getResult();
        XmlEntity xmlEntity = funcResults.stream().filter(CliFunctionResult::isSuccessful).map(CliFunctionResult::getXmlEntity).filter(Objects::nonNull).findFirst().orElse(null);
        TabularResultData tabularResult = ResultBuilder.createTabularResultData();
        for (CliFunctionResult cliFunctionResult : funcResults) {
            tabularResult.accumulate("Member", (Object)cliFunctionResult.getMemberIdOrName());
            if (cliFunctionResult.isSuccessful()) {
                tabularResult.accumulate("Status", (Object)"Successfully created lucene index");
                continue;
            }
            tabularResult.accumulate("Status", (Object)("Failed: " + cliFunctionResult.getMessage()));
        }
        CommandResult result = ResultBuilder.buildResult((ResultData)tabularResult);
        if (xmlEntity != null) {
            this.persistClusterConfiguration((Result)result, () -> ((InternalClusterConfigurationService)this.getConfigurationService()).addXmlEntity(xmlEntity, null));
        }
        return result;
    }

    @CliCommand(value={"describe lucene index"}, help="Display the description of lucene indexes created for all members.")
    @CliMetaData(relatedTopic={"Region", "Data"})
    public Result describeIndex(@CliOption(key={"name"}, mandatory=true, help="Name of the lucene index to describe.") String indexName, @CliOption(key={"region"}, mandatory=true, optionContext="geode.converter.region.path:disable-string-converter", help="Name/Path of the region defining the lucene index to be described.") String regionPath) throws Exception {
        this.authorize(ResourcePermission.Resource.CLUSTER, ResourcePermission.Operation.READ, "LUCENE");
        LuceneIndexInfo indexInfo = new LuceneIndexInfo(indexName, regionPath);
        return this.toTabularResult(this.getIndexDetails(indexInfo), true);
    }

    protected List<LuceneIndexDetails> getIndexDetails(LuceneIndexInfo indexInfo) throws Exception {
        ResultCollector<?, ?> rc = this.executeFunctionOnRegion((Function)describeIndexFunction, indexInfo, true);
        List funcResults = (List)rc.getResult();
        return funcResults.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    @CliCommand(value={"search lucene"}, help="Search lucene index")
    @CliMetaData(relatedTopic={"Region", "Data"})
    public Result searchIndex(@CliOption(key={"name"}, mandatory=true, help="Name of the lucene index to search.") String indexName, @CliOption(key={"region"}, mandatory=true, optionContext="geode.converter.region.path:disable-string-converter", help="Name/Path of the region defining the lucene index to be searched.") String regionPath, @CliOption(key={"queryString", "queryStrings"}, mandatory=true, help="Query string to search the lucene index") String queryString, @CliOption(key={"defaultField"}, mandatory=true, help="Default field to search in") String defaultField, @CliOption(key={"limit"}, unspecifiedDefaultValue="-1", help="Number of search results needed") int limit, @CliOption(key={"keys-only"}, unspecifiedDefaultValue="false", help="Return only keys of search results.") boolean keysOnly) throws Exception {
        this.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, regionPath);
        LuceneQueryInfo queryInfo = new LuceneQueryInfo(indexName, regionPath, queryString, defaultField, limit, keysOnly);
        int pageSize = Integer.MAX_VALUE;
        this.searchResults = this.getSearchResults(queryInfo);
        return this.displayResults(pageSize, keysOnly);
    }

    @CliCommand(value={"destroy lucene index"}, help="Destroy the lucene index.")
    @CliMetaData(relatedTopic={"Region", "Data"})
    public Result destroyIndex(@CliOption(key={"name"}, help="Name of the lucene index to destroy.") String indexName, @CliOption(key={"region"}, mandatory=true, optionContext="geode.converter.region.path:disable-string-converter", help="Name of the region defining the lucene index to be destroyed.") String regionPath) {
        if (indexName != null && StringUtils.isEmpty((String)indexName)) {
            return ResultBuilder.createInfoResult((String)CliStrings.format((String)"Index cannot be empty.", (Object[])new Object[0]));
        }
        this.authorize(ResourcePermission.Resource.CLUSTER, ResourcePermission.Operation.MANAGE, "LUCENE");
        ArrayList<CliFunctionResult> accumulatedResults = new ArrayList<CliFunctionResult>();
        XmlEntity xmlEntity = this.executeDestroyIndexFunction(accumulatedResults, indexName, regionPath);
        Result result = this.getDestroyIndexResult(accumulatedResults, indexName, regionPath);
        if (xmlEntity != null) {
            this.persistClusterConfiguration(result, () -> ((InternalClusterConfigurationService)this.getConfigurationService()).deleteXmlEntity(xmlEntity, null));
        }
        return result;
    }

    private XmlEntity executeDestroyIndexFunction(List<CliFunctionResult> accumulatedResults, String indexName, String regionPath) {
        XmlEntity xmlEntity = null;
        Set regionMembers = this.findMembersForRegion(regionPath);
        Set normalMembers = this.getAllNormalMembers();
        LuceneDestroyIndexInfo indexInfo = new LuceneDestroyIndexInfo(indexName, regionPath);
        if (regionMembers.isEmpty()) {
            indexInfo.setDefinedDestroyOnly(true);
            ResultCollector rc = this.executeFunction((Function)destroyIndexFunction, indexInfo, normalMembers);
            accumulatedResults.addAll((List)rc.getResult());
        } else {
            indexInfo.setDefinedDestroyOnly(false);
            HashSet singleMember = new HashSet();
            singleMember.add(regionMembers.iterator().next());
            ResultCollector rc = this.executeFunction((Function)destroyIndexFunction, indexInfo, singleMember);
            List cliFunctionResults = (List)rc.getResult();
            CliFunctionResult cliFunctionResult = (CliFunctionResult)cliFunctionResults.get(0);
            xmlEntity = cliFunctionResult.getXmlEntity();
            for (DistributedMember regionMember : regionMembers) {
                accumulatedResults.add(new CliFunctionResult(regionMember.getId(), cliFunctionResult.isSuccessful(), cliFunctionResult.getMessage()));
            }
            if (cliFunctionResult.isSuccessful()) {
                normalMembers.removeAll(regionMembers);
                if (!normalMembers.isEmpty()) {
                    indexInfo.setDefinedDestroyOnly(true);
                    rc = this.executeFunction((Function)destroyIndexFunction, indexInfo, normalMembers);
                    accumulatedResults.addAll((List)rc.getResult());
                }
            }
        }
        return xmlEntity;
    }

    private Result getDestroyIndexResult(List<CliFunctionResult> cliFunctionResults, String indexName, String regionPath) {
        TabularResultData tabularResult = ResultBuilder.createTabularResultData();
        for (CliFunctionResult cliFunctionResult : cliFunctionResults) {
            tabularResult.accumulate("Member", (Object)cliFunctionResult.getMemberIdOrName());
            if (cliFunctionResult.isSuccessful()) {
                tabularResult.accumulate("Status", (Object)(indexName == null ? CliStrings.format((String)"Successfully destroyed all lucene indexes from region {0}", (Object[])new Object[]{regionPath}) : CliStrings.format((String)"Successfully destroyed lucene index {0} from region {1}", (Object[])new Object[]{indexName, regionPath})));
                continue;
            }
            tabularResult.accumulate("Status", (Object)cliFunctionResult.getMessage());
        }
        return ResultBuilder.buildResult((ResultData)tabularResult);
    }

    private Result displayResults(int pageSize, boolean keysOnly) throws Exception {
        if (this.searchResults.size() == 0) {
            return ResultBuilder.createInfoResult((String)"No results");
        }
        Gfsh gfsh = this.initGfsh();
        boolean pagination = this.searchResults.size() > pageSize;
        int fromIndex = 0;
        int toIndex = pageSize < this.searchResults.size() ? pageSize : this.searchResults.size();
        int currentPage = 1;
        int totalPages = (int)Math.ceil((float)this.searchResults.size() / (float)pageSize);
        boolean skipDisplay = false;
        String step = null;
        block10: while (true) {
            if (!skipDisplay) {
                CommandResult commandResult = (CommandResult)this.getResults(fromIndex, toIndex, keysOnly);
                if (!pagination) {
                    return commandResult;
                }
                Gfsh.println();
                while (commandResult.hasNextLine()) {
                    gfsh.printAsInfo(commandResult.nextLine());
                }
                gfsh.printAsInfo("\t\tPage " + currentPage + " of " + totalPages);
                String message = "Press n to move to next page, q to quit and p to previous page : ";
                step = gfsh.interact(message);
            }
            switch (step) {
                case "n": {
                    if (currentPage == totalPages) {
                        gfsh.printAsInfo("No more results to display.");
                        step = gfsh.interact("Press p to move to last page and q to quit.");
                        skipDisplay = true;
                        continue block10;
                    }
                    if (skipDisplay) {
                        skipDisplay = false;
                        continue block10;
                    }
                    ++currentPage;
                    int current = fromIndex;
                    fromIndex = toIndex;
                    toIndex = pageSize + fromIndex >= this.searchResults.size() ? this.searchResults.size() : pageSize + fromIndex;
                    continue block10;
                }
                case "p": {
                    if (currentPage == 1) {
                        gfsh.printAsInfo("At the top of the search results.");
                        step = gfsh.interact("Press n to move to the first page and q to quit.");
                        skipDisplay = true;
                        continue block10;
                    }
                    if (skipDisplay) {
                        skipDisplay = false;
                        continue block10;
                    }
                    --currentPage;
                    int current = fromIndex;
                    toIndex = fromIndex;
                    fromIndex = current - pageSize <= 0 ? 0 : current - pageSize;
                    continue block10;
                }
                case "q": {
                    return ResultBuilder.createInfoResult((String)"Search complete.");
                }
            }
            Gfsh.println((Object)"Invalid option");
        }
    }

    protected Gfsh initGfsh() {
        return Gfsh.getCurrentInstance();
    }

    private List<LuceneSearchResults> getSearchResults(LuceneQueryInfo queryInfo) throws Exception {
        String[] groups = new String[]{};
        ResultCollector<?, ?> rc = this.executeSearch(queryInfo);
        List functionResults = (List)rc.getResult();
        return functionResults.stream().flatMap(Collection::stream).sorted().collect(Collectors.toList());
    }

    private Result getResults(int fromIndex, int toIndex, boolean keysonly) throws Exception {
        TabularResultData data = ResultBuilder.createTabularResultData();
        for (int i = fromIndex; i < toIndex; ++i) {
            if (!this.searchResults.get(i).getExceptionFlag()) {
                data.accumulate("key", (Object)this.searchResults.get(i).getKey());
                if (keysonly) continue;
                data.accumulate("value", (Object)this.searchResults.get(i).getValue());
                data.accumulate("score", (Object)Float.valueOf(this.searchResults.get(i).getScore()));
                continue;
            }
            throw new UserErrorException(this.searchResults.get(i).getExceptionMessage());
        }
        return ResultBuilder.buildResult((ResultData)data);
    }

    protected ResultCollector<?, ?> executeFunctionOnAllMembers(Function function, LuceneFunctionSerializable functionArguments) throws IllegalArgumentException {
        Set targetMembers = this.getAllNormalMembers();
        return this.executeFunction(function, functionArguments, targetMembers);
    }

    protected ResultCollector<?, ?> executeSearch(LuceneQueryInfo queryInfo) throws Exception {
        return this.executeFunctionOnRegion((Function)searchIndexFunction, queryInfo, false);
    }

    protected ResultCollector<?, ?> executeFunctionOnRegion(Function function, LuceneFunctionSerializable functionArguments, boolean returnAllMembers) {
        Set targetMembers = CliUtil.getRegionAssociatedMembers((String)functionArguments.getRegionPath(), (InternalCache)((InternalCache)this.getCache()), (boolean)returnAllMembers);
        if (targetMembers.isEmpty()) {
            throw new UserErrorException(CliStrings.format((String)"Could not find any members defining region {0}.", (Object[])new Object[]{functionArguments.getRegionPath()}));
        }
        return this.executeFunction(function, functionArguments, targetMembers);
    }

    @CliAvailabilityIndicator(value={"search lucene", "create lucene index", "describe lucene index", "list lucene indexes", "destroy lucene index"})
    public boolean indexCommandsAvailable() {
        Gfsh gfsh = Gfsh.getCurrentInstance();
        if (gfsh == null) {
            return true;
        }
        return gfsh.isConnectedAndReady();
    }
}

