/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.annotations.Experimental;

@Experimental
public class ClusterManagementResult {
    protected StatusCode statusCode = StatusCode.OK;
    private String statusMessage;
    private String uri;

    public ClusterManagementResult() {
    }

    public ClusterManagementResult(StatusCode statusCode, String message) {
        this.setStatus(statusCode, message);
    }

    public ClusterManagementResult(ClusterManagementResult copyFrom) {
        this.statusCode = copyFrom.statusCode;
        this.statusMessage = copyFrom.statusMessage;
        this.uri = copyFrom.uri;
    }

    public void setStatus(StatusCode statusCode, String message) {
        this.statusCode = statusCode;
        this.statusMessage = ClusterManagementResult.formatErrorMessage(message);
    }

    private static String formatErrorMessage(String message) {
        if (StringUtils.isBlank((CharSequence)message)) {
            return message;
        }
        char firstChar = (message = message.trim()).charAt(0);
        char newFirstChar = Character.toUpperCase(firstChar);
        if (newFirstChar != firstChar) {
            message = newFirstChar + message.substring(1);
        }
        if (!(message.endsWith(".") || message.endsWith("!") || message.endsWith("?"))) {
            message = message + ".";
        }
        return message;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    @JsonIgnore
    public boolean isSuccessful() {
        return this.statusCode == StatusCode.OK || this.statusCode == StatusCode.ACCEPTED || this.statusCode == StatusCode.IN_PROGRESS;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public String toString() {
        if (StringUtils.isBlank((CharSequence)this.getStatusMessage())) {
            return this.getStatusCode().toString();
        }
        return (Object)((Object)this.getStatusCode()) + ": " + this.getStatusMessage();
    }

    public static enum StatusCode {
        ILLEGAL_ARGUMENT,
        UNAUTHENTICATED,
        UNAUTHORIZED,
        ENTITY_EXISTS,
        ENTITY_NOT_FOUND,
        ERROR,
        FAIL_TO_PERSIST,
        ACCEPTED,
        IN_PROGRESS,
        OK;

    }
}

