/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.geode.management.api.ClusterManagementException;
import org.apache.geode.management.api.ClusterManagementGetResult;
import org.apache.geode.management.api.ClusterManagementListOperationsResult;
import org.apache.geode.management.api.ClusterManagementListResult;
import org.apache.geode.management.api.ClusterManagementOperation;
import org.apache.geode.management.api.ClusterManagementOperationResult;
import org.apache.geode.management.api.ClusterManagementRealizationResult;
import org.apache.geode.management.api.ClusterManagementResult;
import org.apache.geode.management.api.ClusterManagementService;
import org.apache.geode.management.configuration.AbstractConfiguration;
import org.apache.geode.management.internal.CompletableFutureProxy;
import org.apache.geode.management.runtime.OperationResult;
import org.apache.geode.management.runtime.RuntimeInfo;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class ClientClusterManagementService
implements ClusterManagementService {
    private final RestTemplate restTemplate;
    private final ScheduledExecutorService longRunningStatusPollingThreadPool;

    ClientClusterManagementService(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
        this.longRunningStatusPollingThreadPool = Executors.newScheduledThreadPool(1);
    }

    @Override
    public <T extends AbstractConfiguration<?>> ClusterManagementRealizationResult create(T config) {
        String endPoint = "/v1" + config.getLinks().getList();
        return (ClusterManagementRealizationResult)this.assertSuccessful((ClusterManagementResult)this.restTemplate.exchange(endPoint, HttpMethod.POST, ClientClusterManagementService.makeEntity(config), ClusterManagementRealizationResult.class, new Object[0]).getBody());
    }

    static <T> HttpEntity<T> makeEntity(T config) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("X-Include-Class", "true");
        return new HttpEntity(config, (MultiValueMap)headers);
    }

    @Override
    public <T extends AbstractConfiguration<?>> ClusterManagementRealizationResult delete(T config) {
        String uri = this.getIdentityEndpoint(config);
        return (ClusterManagementRealizationResult)this.assertSuccessful((ClusterManagementResult)this.restTemplate.exchange(uri + "?group={group}", HttpMethod.DELETE, ClientClusterManagementService.makeEntity(null), ClusterManagementRealizationResult.class, new Object[]{config.getGroup()}).getBody());
    }

    @Override
    public <T extends AbstractConfiguration<?>> ClusterManagementRealizationResult update(T config) {
        throw new NotImplementedException("Not Implemented");
    }

    @Override
    public <T extends AbstractConfiguration<R>, R extends RuntimeInfo> ClusterManagementListResult<T, R> list(T config) {
        String endPoint = "/v1" + config.getLinks().getList();
        return (ClusterManagementListResult)this.assertSuccessful((ClusterManagementResult)this.restTemplate.exchange(endPoint + "/?id={id}&group={group}", HttpMethod.GET, ClientClusterManagementService.makeEntity(config), ClusterManagementListResult.class, new Object[]{config.getId(), config.getGroup()}).getBody());
    }

    @Override
    public <T extends AbstractConfiguration<R>, R extends RuntimeInfo> ClusterManagementGetResult<T, R> get(T config) {
        return (ClusterManagementGetResult)this.assertSuccessful((ClusterManagementResult)this.restTemplate.exchange(this.getIdentityEndpoint(config), HttpMethod.GET, ClientClusterManagementService.makeEntity(config), ClusterManagementGetResult.class, new Object[0]).getBody());
    }

    @Override
    public <A extends ClusterManagementOperation<V>, V extends OperationResult> ClusterManagementOperationResult<V> start(A op) {
        ClusterManagementOperationResult result = (ClusterManagementOperationResult)this.assertSuccessful((ClusterManagementResult)this.restTemplate.exchange("/v1" + op.getEndpoint(), HttpMethod.POST, ClientClusterManagementService.makeEntity(op), ClusterManagementOperationResult.class, new Object[0]).getBody());
        return this.reAnimate(result, op.getEndpoint());
    }

    private <V extends OperationResult> ClusterManagementOperationResult<V> reAnimate(ClusterManagementOperationResult<V> result, String endPoint) {
        String uri = "/v1" + endPoint + "/" + result.getOperationId();
        CompletableFuture<Date> futureOperationEnded = new CompletableFuture<Date>();
        CompletableFutureProxy operationResult = new CompletableFutureProxy(this.restTemplate, uri, this.longRunningStatusPollingThreadPool, futureOperationEnded);
        return new ClusterManagementOperationResult(result, operationResult, result.getOperationStart(), futureOperationEnded, result.getOperator(), result.getOperationId());
    }

    @Override
    public <A extends ClusterManagementOperation<V>, V extends OperationResult> ClusterManagementListOperationsResult<V> list(A opType) {
        ClusterManagementListOperationsResult result = (ClusterManagementListOperationsResult)this.assertSuccessful((ClusterManagementResult)this.restTemplate.exchange("/v1" + opType.getEndpoint(), HttpMethod.GET, ClientClusterManagementService.makeEntity(null), ClusterManagementListOperationsResult.class, new Object[0]).getBody());
        return new ClusterManagementListOperationsResult(result.getResult().stream().map(r -> this.reAnimate((ClusterManagementOperationResult)r, opType.getEndpoint())).collect(Collectors.toList()));
    }

    private String getIdentityEndpoint(AbstractConfiguration config) {
        String uri = config.getLinks().getSelf();
        if (uri == null) {
            throw new IllegalArgumentException("Unable to construct the URI with the current configuration.");
        }
        return "/v1" + uri;
    }

    private <T extends ClusterManagementResult> T assertSuccessful(T result) {
        if (result == null) {
            ClusterManagementResult somethingVeryBadHappened = new ClusterManagementResult(ClusterManagementResult.StatusCode.ERROR, "Unable to parse server response.");
            throw new ClusterManagementException(somethingVeryBadHappened);
        }
        if (!result.isSuccessful()) {
            throw new ClusterManagementException(result);
        }
        return result;
    }

    @Override
    public boolean isConnected() {
        try {
            return ((String)this.restTemplate.getForEntity("/v1/ping", String.class, new Object[0]).getBody()).equals("pong");
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void close() {
        this.longRunningStatusPollingThreadPool.shutdownNow();
    }
}

