/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.geode.distributed.internal.membership.api.MemberData;
import org.apache.geode.distributed.internal.membership.api.MemberDataBuilder;
import org.apache.geode.distributed.internal.membership.gms.GMSMemberData;
import org.apache.geode.internal.inet.LocalHostUtil;
import org.apache.geode.internal.serialization.KnownVersion;

public class MemberDataBuilderImpl
implements MemberDataBuilder {
    private static final String EMPTY_STRING = "";
    private InetAddress inetAddress;
    private String hostName;
    private int membershipPort = -1;
    private int directChannelPort = -1;
    private int vmPid = -1;
    private int vmKind = 10;
    private int vmViewId = -1;
    private String name = "";
    private String[] groups;
    private String durableId;
    private int durableTimeout = -1;
    private boolean preferredForCoordinator = true;
    private boolean networkPartitionDetectionEnabled;
    private short versionOrdinal = KnownVersion.CURRENT_ORDINAL;
    private long uuidMostSignificantBits = 0L;
    private long uuidLeastSignificantBits = 0L;
    private boolean isPartial;
    private String uniqueTag;
    private byte memberWeight = 0;

    public void setMemberWeight(byte memberWeight) {
        this.memberWeight = memberWeight;
    }

    public static MemberDataBuilderImpl newBuilder(InetAddress hostAddress, String hostName) {
        return new MemberDataBuilderImpl(hostAddress, hostName);
    }

    public static MemberDataBuilderImpl newBuilderForLocalHost(String hostName) {
        return new MemberDataBuilderImpl(hostName);
    }

    private MemberDataBuilderImpl(InetAddress hostAddress, String hostName) {
        this.inetAddress = hostAddress;
        this.hostName = hostName;
    }

    private MemberDataBuilderImpl(String hostName) {
        try {
            this.inetAddress = LocalHostUtil.getLocalHost();
        }
        catch (UnknownHostException e2) {
            throw new RuntimeException("Unable to resolve local host address", e2);
        }
        this.hostName = hostName;
    }

    @Override
    public MemberDataBuilderImpl setMembershipPort(int membershipPort) {
        this.membershipPort = membershipPort;
        return this;
    }

    @Override
    public MemberDataBuilderImpl setDirectChannelPort(int directChannelPort) {
        this.directChannelPort = directChannelPort;
        return this;
    }

    @Override
    public MemberDataBuilderImpl setVmPid(int vmPid) {
        this.vmPid = vmPid;
        return this;
    }

    @Override
    public MemberDataBuilderImpl setVmKind(int vmKind) {
        this.vmKind = vmKind;
        return this;
    }

    @Override
    public MemberDataBuilderImpl setVmViewId(int vmViewId) {
        this.vmViewId = vmViewId;
        return this;
    }

    @Override
    public MemberDataBuilderImpl setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public MemberDataBuilderImpl setGroups(String[] groups) {
        this.groups = groups;
        return this;
    }

    @Override
    public MemberDataBuilderImpl setDurableId(String durableId) {
        this.durableId = durableId;
        return this;
    }

    @Override
    public MemberDataBuilderImpl setDurableTimeout(int durableTimeout) {
        this.durableTimeout = durableTimeout;
        return this;
    }

    @Override
    public MemberDataBuilderImpl setPreferredForCoordinator(boolean preferredForCoordinator) {
        this.preferredForCoordinator = preferredForCoordinator;
        return this;
    }

    @Override
    public MemberDataBuilderImpl setNetworkPartitionDetectionEnabled(boolean networkPartitionDetectionEnabled) {
        this.networkPartitionDetectionEnabled = networkPartitionDetectionEnabled;
        return this;
    }

    @Override
    public MemberDataBuilderImpl setVersionOrdinal(short versionOrdinal) {
        this.versionOrdinal = versionOrdinal;
        return this;
    }

    @Override
    public MemberDataBuilderImpl setUuidMostSignificantBits(long uuidMostSignificantBits) {
        this.uuidMostSignificantBits = uuidMostSignificantBits;
        return this;
    }

    @Override
    public MemberDataBuilderImpl setUuidLeastSignificantBits(long uuidLeastSignificantBits) {
        this.uuidLeastSignificantBits = uuidLeastSignificantBits;
        return this;
    }

    @Override
    public MemberDataBuilderImpl setIsPartial(boolean partial) {
        this.isPartial = partial;
        return this;
    }

    @Override
    public MemberDataBuilder setUniqueTag(String uniqueTag) {
        this.uniqueTag = uniqueTag;
        return this;
    }

    @Override
    public MemberData build() {
        return new GMSMemberData(this.inetAddress, this.hostName, this.membershipPort, this.vmPid, (byte)this.vmKind, this.directChannelPort, this.vmViewId, this.name, this.groups, this.durableId, this.durableTimeout, this.networkPartitionDetectionEnabled, this.preferredForCoordinator, this.versionOrdinal, this.uuidMostSignificantBits, this.uuidLeastSignificantBits, this.memberWeight, this.isPartial, this.uniqueTag);
    }
}

