/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.locator;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.geode.distributed.internal.membership.gms.locator.PeerLocatorRequest;
import org.apache.geode.distributed.internal.tcpserver.TcpHandler;
import org.apache.geode.distributed.internal.tcpserver.TcpServer;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class PrimaryHandler
implements TcpHandler {
    private static final Logger logger = LogService.getLogger();
    private final TcpHandler fallbackHandler;
    private volatile Map<Class<?>, TcpHandler> handlerMapping = new HashMap();
    private volatile Set<TcpHandler> allHandlers = new HashSet<TcpHandler>();
    private TcpServer tcpServer;
    private final int locatorWaitTime;
    private final MillisecondProvider millisecondProvider;
    private final Sleeper sleeper;

    PrimaryHandler(TcpHandler fallbackHandler, int locatorWaitTime, MillisecondProvider millisecondProvider, Sleeper sleeper) {
        this.locatorWaitTime = locatorWaitTime;
        this.fallbackHandler = fallbackHandler;
        this.millisecondProvider = millisecondProvider;
        this.sleeper = sleeper;
        this.allHandlers.add(fallbackHandler);
    }

    public synchronized void init(TcpServer tcpServer) {
        this.tcpServer = tcpServer;
        for (TcpHandler handler : this.allHandlers) {
            handler.init(tcpServer);
        }
    }

    public Object processRequest(Object request) throws IOException {
        long giveup = 0L;
        while (giveup == 0L || this.millisecondProvider.millisecondTime() < giveup) {
            TcpHandler handler = request instanceof PeerLocatorRequest ? this.handlerMapping.get(PeerLocatorRequest.class) : this.handlerMapping.get(request.getClass());
            if (handler != null) {
                return handler.processRequest(request);
            }
            if (this.fallbackHandler != null) {
                return this.fallbackHandler.processRequest(request);
            }
            if (giveup == 0L) {
                int locatorWaitTime = this.locatorWaitTime;
                if (locatorWaitTime <= 0) {
                    locatorWaitTime = 30;
                }
                giveup = this.millisecondProvider.millisecondTime() + (long)locatorWaitTime * 1000L;
            }
            try {
                this.sleeper.sleep(1000L);
            }
            catch (InterruptedException ignored) {
                return null;
            }
        }
        logger.info("Received a location request of class {} but the handler for this is either not enabled or is not ready to process requests", (Object)request.getClass().getSimpleName());
        return null;
    }

    public void shutDown() {
        for (TcpHandler handler : this.allHandlers) {
            try {
                handler.shutDown();
            }
            catch (Throwable e) {
                logger.error("Caught exception shutting down handler", e);
            }
        }
    }

    synchronized boolean isHandled(Class<?> clazz) {
        return this.handlerMapping.containsKey(clazz);
    }

    public synchronized void addHandler(Class<?> clazz, TcpHandler handler) {
        HashMap tmpHandlerMapping = new HashMap(this.handlerMapping);
        HashSet<TcpHandler> tmpAllHandlers = new HashSet<TcpHandler>(this.allHandlers);
        tmpHandlerMapping.put(clazz, handler);
        if (tmpAllHandlers.add(handler) && this.tcpServer != null) {
            handler.init(this.tcpServer);
        }
        this.handlerMapping = tmpHandlerMapping;
        this.allHandlers = tmpAllHandlers;
    }

    public void endRequest(Object request, long startTime) {
        TcpHandler handler = this.handlerMapping.get(request.getClass());
        if (handler != null) {
            handler.endRequest(request, startTime);
        }
    }

    public void endResponse(Object request, long startTime) {
        TcpHandler handler = this.handlerMapping.get(request.getClass());
        if (handler != null) {
            handler.endResponse(request, startTime);
        }
    }

    @FunctionalInterface
    static interface MillisecondProvider {
        public long millisecondTime();
    }

    @FunctionalInterface
    static interface Sleeper {
        public void sleep(long var1) throws InterruptedException;
    }
}

