/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.tcpserver;

import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLException;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.distributed.internal.tcpserver.InfoRequest;
import org.apache.geode.distributed.internal.tcpserver.InfoResponse;
import org.apache.geode.distributed.internal.tcpserver.ShutdownRequest;
import org.apache.geode.distributed.internal.tcpserver.TcpServer;
import org.apache.geode.distributed.internal.tcpserver.TcpSocketCreator;
import org.apache.geode.distributed.internal.tcpserver.VersionRequest;
import org.apache.geode.distributed.internal.tcpserver.VersionResponse;
import org.apache.geode.internal.serialization.ObjectDeserializer;
import org.apache.geode.internal.serialization.ObjectSerializer;
import org.apache.geode.internal.serialization.UnsupportedSerializationVersionException;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.internal.serialization.VersionedDataInputStream;
import org.apache.geode.internal.serialization.VersionedDataOutputStream;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class TcpClient {
    private static final Logger logger = LogService.getLogger();
    private static final int DEFAULT_REQUEST_TIMEOUT = 120000;
    @MakeNotStatic
    private static final Map<InetSocketAddress, Short> serverVersions = new HashMap<InetSocketAddress, Short>();
    private final TcpSocketCreator socketCreator;
    private final ObjectSerializer objectSerializer;
    private final ObjectDeserializer objectDeserializer;

    public TcpClient(TcpSocketCreator socketCreator, ObjectSerializer objectSerializer, ObjectDeserializer objectDeserializer) {
        this.socketCreator = socketCreator;
        this.objectSerializer = objectSerializer;
        this.objectDeserializer = objectDeserializer;
    }

    public void stop(InetAddress addr, int port) throws ConnectException {
        try {
            ShutdownRequest request = new ShutdownRequest();
            this.requestToServer(addr, port, request, 120000);
        }
        catch (ConnectException ce) {
            throw ce;
        }
        catch (Exception ex) {
            logger.error("TcpClient.stop(): exception connecting to locator " + addr + ":" + port + ": " + ex);
        }
    }

    public String[] getInfo(InetAddress addr, int port) {
        try {
            InfoRequest request = new InfoRequest();
            InfoResponse response = (InfoResponse)this.requestToServer(addr, port, request, 120000);
            return response.getInfo();
        }
        catch (ConnectException ignore) {
            return null;
        }
        catch (Exception ex) {
            logger.error("TcpClient.getInfo(): exception connecting to locator " + addr + ":" + port + ": " + ex);
            return null;
        }
    }

    public Object requestToServer(InetAddress addr, int port, Object request, int timeout) throws IOException, ClassNotFoundException {
        return this.requestToServer(addr, port, request, timeout, true);
    }

    public Object requestToServer(InetAddress addr, int port, Object request, int timeout, boolean replyExpected) throws IOException, ClassNotFoundException {
        InetSocketAddress ipAddr = addr == null ? new InetSocketAddress(port) : new InetSocketAddress(addr, port);
        return this.requestToServer(ipAddr, request, timeout, replyExpected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object requestToServer(InetSocketAddress ipAddr, Object request, int timeout, boolean replyExpected) throws IOException, ClassNotFoundException {
        long newTimeout;
        long giveupTime = System.currentTimeMillis() + (long)timeout;
        short serverVersion = this.getServerVersion(ipAddr, timeout);
        if (serverVersion > Version.CURRENT_ORDINAL) {
            serverVersion = Version.CURRENT_ORDINAL;
        }
        int gossipVersion = TcpServer.getCurrentGossipVersion();
        if (Version.GFE_71.compareTo(serverVersion) > 0) {
            gossipVersion = TcpServer.getOldGossipVersion();
        }
        if ((newTimeout = giveupTime - System.currentTimeMillis()) <= 0L) {
            return null;
        }
        logger.debug("TcpClient sending {} to {}", request, (Object)ipAddr);
        Socket sock = this.socketCreator.connect(ipAddr.getAddress(), ipAddr.getPort(), (int)newTimeout, null, false);
        sock.setSoTimeout((int)newTimeout);
        DataOutputStream out = null;
        try {
            out = new DataOutputStream(new BufferedOutputStream(sock.getOutputStream()));
            if (serverVersion < Version.CURRENT_ORDINAL) {
                out = new VersionedDataOutputStream((OutputStream)out, Version.fromOrdinalNoThrow((short)serverVersion, (boolean)false));
            }
            out.writeInt(gossipVersion);
            if (gossipVersion > TcpServer.getOldGossipVersion()) {
                out.writeShort(serverVersion);
            }
            this.objectSerializer.writeObject(request, (DataOutput)out);
            out.flush();
            if (replyExpected) {
                DataInputStream in = new DataInputStream(sock.getInputStream());
                in = new VersionedDataInputStream((InputStream)in, Version.fromOrdinal((short)serverVersion));
                try {
                    Object response = this.objectDeserializer.readObject((DataInput)in);
                    logger.debug("received response: {}", response);
                    Object object = response;
                    return object;
                }
                catch (EOFException ex) {
                    logger.debug("requestToServer EOFException ", (Throwable)ex);
                    EOFException eof = new EOFException("Locator at " + ipAddr + " did not respond. This is normal if the locator was shutdown. If it wasn't check its log for exceptions.");
                    eof.initCause(ex);
                    throw eof;
                }
            }
            Object in = null;
            return in;
        }
        catch (UnsupportedSerializationVersionException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug("Remote TcpServer version: " + serverVersion + " is higher than local version: " + Version.CURRENT_ORDINAL + ". This is never expected as remoteVersion");
            }
            Object var14_17 = null;
            return var14_17;
        }
        finally {
            try {
                if (replyExpected && !sock.isClosed() && !this.socketCreator.useSSL()) {
                    sock.setSoLinger(true, 0);
                }
                sock.close();
            }
            catch (Exception e) {
                logger.error("Error closing socket ", (Throwable)e);
            }
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Short getServerVersion(InetSocketAddress ipAddr, int timeout) throws IOException, ClassNotFoundException {
        Socket sock;
        Short serverVersion;
        Map<InetSocketAddress, Short> map = serverVersions;
        synchronized (map) {
            serverVersion = serverVersions.get(ipAddr);
        }
        if (serverVersion != null) {
            return serverVersion;
        }
        int gossipVersion = TcpServer.getOldGossipVersion();
        try {
            sock = this.socketCreator.connect(ipAddr.getAddress(), ipAddr.getPort(), timeout, null, false);
            sock.setSoTimeout(timeout);
        }
        catch (SSLException e) {
            throw new IllegalStateException("Unable to form SSL connection", e);
        }
        BufferedOutputStream outputStream = new BufferedOutputStream(sock.getOutputStream());
        VersionedDataOutputStream out = new VersionedDataOutputStream((OutputStream)new DataOutputStream(outputStream), Version.GFE_57);
        out.writeInt(gossipVersion);
        VersionRequest verRequest = new VersionRequest();
        this.objectSerializer.writeObject((Object)verRequest, (DataOutput)out);
        out.flush();
        InputStream inputStream = sock.getInputStream();
        DataInputStream in = new DataInputStream(inputStream);
        in = new VersionedDataInputStream((InputStream)in, Version.GFE_57);
        Object readObject = this.objectDeserializer.readObject((DataInput)in);
        if (!(readObject instanceof VersionResponse)) {
            throw new IllegalThreadStateException("Server version response invalid: This could be the result of trying to connect a non-SSL-enabled client to an SSL-enabled locator.");
        }
        VersionResponse response = (VersionResponse)readObject;
        serverVersion = response.getVersionOrdinal();
        Object object = serverVersions;
        synchronized (object) {
            serverVersions.put(ipAddr, serverVersion);
        }
        object = serverVersion;
        try {
            sock.setSoLinger(true, 0);
        }
        catch (Exception e) {
            logger.error("Error aborting socket ", (Throwable)e);
        }
        try {
            sock.close();
        }
        catch (Exception e) {
            logger.error("Error closing socket ", (Throwable)e);
        }
        return object;
        {
            catch (EOFException eOFException) {
                try {
                    sock.setSoLinger(true, 0);
                }
                catch (Exception e) {
                    logger.error("Error aborting socket ", (Throwable)e);
                }
                try {
                    sock.close();
                }
                catch (Exception e) {
                    logger.error("Error closing socket ", (Throwable)e);
                }
                catch (Throwable throwable) {
                    try {
                        sock.setSoLinger(true, 0);
                    }
                    catch (Exception e) {
                        logger.error("Error aborting socket ", (Throwable)e);
                    }
                    try {
                        sock.close();
                    }
                    catch (Exception e) {
                        logger.error("Error closing socket ", (Throwable)e);
                    }
                    throw throwable;
                }
            }
        }
        map = serverVersions;
        synchronized (map) {
            serverVersions.put(ipAddr, Version.GFE_57.ordinal());
        }
        return Version.GFE_57.ordinal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearStaticData() {
        Map<InetSocketAddress, Short> map = serverVersions;
        synchronized (map) {
            serverVersions.clear();
        }
    }
}

