/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.fork;

import org.apache.gobblin.fork.CopyNotSupportedException;
import org.apache.gobblin.fork.Copyable;

public class CopyHelper {
    public static boolean isCopyable(Object thing) {
        return thing instanceof Copyable || thing instanceof byte[] || CopyHelper.isImmutableType(thing);
    }

    private static boolean isImmutableType(Object thing) {
        return thing == null || thing instanceof String || thing instanceof Integer || thing instanceof Long;
    }

    public static Object copy(Object thing) throws CopyNotSupportedException {
        if (!CopyHelper.isCopyable(thing)) {
            throw new CopyNotSupportedException(thing.getClass().getName() + " cannot be copied. See Copyable");
        }
        if (thing instanceof Copyable) {
            return ((Copyable)thing).copy();
        }
        if (thing instanceof byte[]) {
            byte[] copy = new byte[((byte[])thing).length];
            System.arraycopy(thing, 0, copy, 0, ((byte[])thing).length);
            return copy;
        }
        return thing;
    }
}

