/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.api;

import com.typesafe.config.Config;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.gobblin.runtime.api.ServiceNode;
import org.apache.gobblin.runtime.api.Spec;
import org.apache.gobblin.runtime.api.SpecProducer;

public interface SpecExecutor {
    public static final String VERB_KEY = "Verb";

    public URI getUri();

    public Future<String> getDescription();

    public Future<Config> getConfig();

    public Config getAttrs();

    public Future<String> getHealth();

    public Future<? extends Map<ServiceNode, ServiceNode>> getCapabilities();

    public Future<? extends SpecProducer<Spec>> getProducer();

    public static enum Verb {
        ADD(1, "add"),
        UPDATE(2, "update"),
        DELETE(3, "delete"),
        UNKNOWN(4, "unknown"),
        CANCEL(5, "cancel");

        private int _id;
        private String _verb;

        private Verb(int id, String verb) {
            this._id = id;
            this._verb = verb;
        }

        public int getId() {
            return this._id;
        }

        public String getVerb() {
            return this._verb;
        }
    }
}

