/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.broker;

import com.google.common.base.Joiner;
import javax.annotation.Nonnull;
import org.apache.gobblin.broker.iface.ScopeType;
import org.apache.gobblin.broker.iface.SharedResourceFactory;
import org.apache.gobblin.broker.iface.SharedResourceKey;

public class BrokerConfigurationKeyGenerator {
    private static final Joiner JOINER = Joiner.on((String)".").skipNulls();

    public static String generateKey(@Nonnull SharedResourceFactory factory, SharedResourceKey key, ScopeType scopeType, @Nonnull String configKey) {
        return JOINER.join((Object)"gobblin.broker", (Object)factory.getName(), new Object[]{scopeType == null ? null : scopeType.name(), key == null ? null : key.toConfigurationKey(), configKey});
    }

    public static StringBuilder builder() {
        return new StringBuilder();
    }

    public static class StringBuilder {
        private SharedResourceFactory factory;
        private SharedResourceKey key;
        private ScopeType scopeType;
        private String configKey;

        StringBuilder() {
        }

        public StringBuilder factory(@Nonnull SharedResourceFactory factory) {
            this.factory = factory;
            return this;
        }

        public StringBuilder key(SharedResourceKey key) {
            this.key = key;
            return this;
        }

        public StringBuilder scopeType(ScopeType scopeType) {
            this.scopeType = scopeType;
            return this;
        }

        public StringBuilder configKey(@Nonnull String configKey) {
            this.configKey = configKey;
            return this;
        }

        public String build() {
            return BrokerConfigurationKeyGenerator.generateKey(this.factory, this.key, this.scopeType, this.configKey);
        }

        public String toString() {
            return "BrokerConfigurationKeyGenerator.StringBuilder(factory=" + this.factory + ", key=" + this.key + ", scopeType=" + this.scopeType + ", configKey=" + this.configKey + ")";
        }
    }
}

