/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.cli;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.gobblin.runtime.cli.CliObjectFactory;
import org.apache.gobblin.runtime.cli.CliObjectOption;
import org.apache.gobblin.runtime.cli.NotOnCli;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PublicMethodsCliObjectFactory<T>
implements CliObjectFactory<T> {
    private static final Logger log = LoggerFactory.getLogger(PublicMethodsCliObjectFactory.class);
    private static final Option HELP = Option.builder((String)"h").longOpt("help").build();
    private static final Option USE_LOG = Option.builder((String)"l").desc("Uses log to print out erros in the base CLI code.").build();
    private static final List<String> BLACKLISTED_FROM_CLI = ImmutableList.of((Object)"getClass", (Object)"hashCode", (Object)"notify", (Object)"notifyAll", (Object)"toString", (Object)"wait");
    protected final Class<? extends T> klazz;
    private final Options options;
    private final Map<String, Method> methodsMap;

    public PublicMethodsCliObjectFactory(Class<? extends T> klazz) {
        this.klazz = klazz;
        this.methodsMap = Maps.newHashMap();
        this.options = this.inferOptionsFromMethods();
    }

    @Override
    public T buildObject(CommandLine cli) {
        try {
            T obj = this.constructObject(cli);
            this.applyCommandLineOptions(cli, obj);
            return obj;
        }
        catch (IOException exc) {
            throw new RuntimeException("Could not instantiate " + this.klazz.getSimpleName(), exc);
        }
    }

    @Override
    public T buildObject(String[] args, int offset, boolean printUsage, String usage) throws IOException {
        CommandLine cli;
        Options options = new Options();
        options.addOption(HELP);
        options.addOption(USE_LOG);
        for (Option opt : this.getOptions().getOptions()) {
            options.addOption(opt);
        }
        try {
            DefaultParser parser = new DefaultParser();
            cli = parser.parse(options, Arrays.copyOfRange(args, offset, args.length));
        }
        catch (ParseException pe) {
            if (printUsage) {
                System.out.println("Command line parse exception: " + pe.getMessage());
                this.printUsage(usage, options);
            }
            throw new IOException(pe);
        }
        if (cli.hasOption(HELP.getOpt())) {
            if (printUsage) {
                this.printUsage(usage, options);
            }
            throw new CliObjectFactory.HelpArgumentFound();
        }
        try {
            return this.buildObject(cli);
        }
        catch (Throwable t) {
            if (cli.hasOption(USE_LOG.getOpt())) {
                log.error("Failed to instantiate " + this.klazz.getName(), t);
            } else {
                System.out.println("Error: " + t.getMessage());
            }
            if (printUsage) {
                this.printUsage(usage, options);
            }
            throw new IOException(t);
        }
    }

    protected abstract T constructObject(CommandLine var1) throws IOException;

    @Override
    public String getUsageString() {
        return "[OPTIONS]";
    }

    public void applyCommandLineOptions(CommandLine cli, T embeddedGobblin) {
        try {
            for (Option option : cli.getOptions()) {
                if (!this.methodsMap.containsKey(option.getOpt())) continue;
                if (option.hasArg()) {
                    this.methodsMap.get(option.getOpt()).invoke(embeddedGobblin, option.getValue());
                    continue;
                }
                this.methodsMap.get(option.getOpt()).invoke(embeddedGobblin, new Object[0]);
            }
        }
        catch (IllegalAccessException | InvocationTargetException exc) {
            throw new RuntimeException("Could not apply options to " + embeddedGobblin.getClass().getName(), exc);
        }
    }

    private Options inferOptionsFromMethods() {
        Options options = new Options();
        for (Method method : this.klazz.getMethods()) {
            boolean hasArg;
            if (!this.canUseMethod(method)) continue;
            CliObjectOption annotation = method.isAnnotationPresent(CliObjectOption.class) ? method.getAnnotation(CliObjectOption.class) : null;
            String optionName = annotation == null || Strings.isNullOrEmpty((String)annotation.name()) ? method.getName() : annotation.name();
            String description = annotation == null ? "" : annotation.description();
            Option.Builder builder = Option.builder((String)optionName).desc(description);
            boolean bl = hasArg = method.getParameterTypes().length > 0;
            if (hasArg) {
                builder.hasArg();
            }
            Option option = builder.build();
            options.addOption(option);
            this.methodsMap.put(option.getOpt(), method);
        }
        return options;
    }

    private boolean canUseMethod(Method method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            return false;
        }
        if (BLACKLISTED_FROM_CLI.contains(method.getName())) {
            return false;
        }
        if (method.isAnnotationPresent(NotOnCli.class)) {
            return false;
        }
        Class<?>[] parameters = method.getParameterTypes();
        if (parameters.length >= 2) {
            return false;
        }
        return parameters.length != 1 || parameters[0] == String.class;
    }

    private void printUsage(String usage, Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setOptionComparator((Comparator)new Comparator<Option>(){

            @Override
            public int compare(Option o1, Option o2) {
                if (o1.isRequired() && !o2.isRequired()) {
                    return -1;
                }
                if (!o1.isRequired() && o2.isRequired()) {
                    return 1;
                }
                return o1.getOpt().compareTo(o2.getOpt());
            }
        });
        formatter.printHelp(usage, options);
    }

    @Override
    public Options getOptions() {
        return this.options;
    }
}

