/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClustersNames {
    public static final String URL_TO_NAME_MAP_RESOURCE_NAME = "GobblinClustersNames.properties";
    private static final Logger LOG = LoggerFactory.getLogger(ClustersNames.class);
    private static final Configuration HADOOP_CONFIGURATION = new Configuration();
    private static ClustersNames THE_INSTANCE;
    private Properties urlToNameMap = new Properties();

    protected ClustersNames() {
        try (Closer closer = Closer.create();){
            InputStream propsInput = (InputStream)closer.register((Closeable)this.getClass().getResourceAsStream(URL_TO_NAME_MAP_RESOURCE_NAME));
            if (null == propsInput) {
                propsInput = (InputStream)closer.register((Closeable)ClassLoader.getSystemResourceAsStream(URL_TO_NAME_MAP_RESOURCE_NAME));
            }
            if (null != propsInput) {
                try {
                    this.urlToNameMap.load(propsInput);
                    LOG.info("Loaded cluster names map:" + this.urlToNameMap);
                }
                catch (IOException e) {
                    LOG.warn("Unable to load cluster names map: " + e, (Throwable)e);
                }
            } else {
                LOG.info("no default cluster mapping found");
            }
        }
        catch (IOException e) {
            LOG.warn("unable to close resource input stream for GobblinClustersNames.properties:" + e, (Throwable)e);
        }
    }

    public String getClusterName(String clusterUrl) {
        if (null == clusterUrl) {
            return null;
        }
        List<String> candidates = ClustersNames.generateUrlMatchCandidates(clusterUrl);
        for (String candidate : candidates) {
            String name = this.urlToNameMap.getProperty(candidate);
            if (name == null) continue;
            return name;
        }
        return candidates.get(candidates.size() - 1);
    }

    public void addClusterMapping(String clusterUrl, String clusterName) {
        Preconditions.checkNotNull((Object)clusterUrl, (Object)"cluster URL expected");
        Preconditions.checkNotNull((Object)clusterName, (Object)"cluster name expected");
        this.urlToNameMap.put(clusterUrl, clusterName);
    }

    public void addClusterMapping(URL clusterUrl, String clusterName) {
        Preconditions.checkNotNull((Object)clusterUrl, (Object)"cluster URL expected");
        Preconditions.checkNotNull((Object)clusterName, (Object)"cluster name expected");
        this.urlToNameMap.put(clusterUrl.toString(), clusterName);
    }

    private static List<String> generateUrlMatchCandidates(String clusterIdentifier) {
        ArrayList<String> candidates = new ArrayList<String>();
        candidates.add(clusterIdentifier);
        try {
            URI uri = new URI(clusterIdentifier.trim());
            if (uri.getHost() != null) {
                if (uri.getPort() != -1) {
                    candidates.add(uri.getHost() + ":" + uri.getPort());
                }
                candidates.add(uri.getHost());
            } else if (uri.getScheme() != null && uri.getPath() != null) {
                candidates.add("localhost");
            } else {
                candidates.add(ClustersNames.getSafeFallbackName(clusterIdentifier));
            }
        }
        catch (URISyntaxException e) {
            candidates.add(ClustersNames.getSafeFallbackName(clusterIdentifier));
        }
        return candidates;
    }

    private static String getSafeFallbackName(String clusterIdentifier) {
        return clusterIdentifier.replaceAll("[^\\w-\\.]", "_");
    }

    public String getClusterName() {
        return this.getClusterName(HADOOP_CONFIGURATION);
    }

    public String getClusterName(Configuration conf) {
        String clusterIdentifier = conf.get("yarn.resourcemanager.address");
        if ((clusterIdentifier = this.getClusterName(clusterIdentifier)) == null || StringUtils.startsWithIgnoreCase((String)clusterIdentifier, (String)"localhost") || StringUtils.startsWithIgnoreCase((String)clusterIdentifier, (String)"0.0.0.0")) {
            try {
                clusterIdentifier = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return clusterIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClustersNames getInstance() {
        Class<ClustersNames> clazz = ClustersNames.class;
        synchronized (ClustersNames.class) {
            if (null == THE_INSTANCE) {
                THE_INSTANCE = new ClustersNames();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return THE_INSTANCE;
        }
    }
}

