/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.lang.StringUtils;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.util.JobConfigurationUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ProxiedFileSystemWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(ProxiedFileSystemWrapper.class);
    private FileSystem proxiedFs;

    public void setProxiedFileSystem(FileSystem currentProxiedFs) {
        this.proxiedFs = currentProxiedFs;
    }

    public FileSystem getProxiedFileSystem(State properties, AuthType authType, String authPath, String uri) throws IOException, InterruptedException, URISyntaxException {
        Configuration conf = new Configuration();
        JobConfigurationUtils.putStateIntoConfiguration(properties, conf);
        return this.getProxiedFileSystem(properties, authType, authPath, uri, conf);
    }

    public FileSystem getProxiedFileSystem(State properties, AuthType authType, String authPath, String uri, final Configuration conf) throws IOException, InterruptedException, URISyntaxException {
        UserGroupInformation proxyUser;
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)properties.getProp("fs.proxy.as.user.name")), (Object)"State does not contain a proper proxy user name");
        String proxyUserName = properties.getProp("fs.proxy.as.user.name");
        switch (authType) {
            case KEYTAB: {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)properties.getProp("super.user.name.to.proxy.as.others")), (Object)"State does not contain a proper proxy token file name");
                String superUser = properties.getProp("super.user.name.to.proxy.as.others");
                UserGroupInformation.loginUserFromKeytab((String)superUser, (String)authPath);
                proxyUser = UserGroupInformation.createProxyUser((String)proxyUserName, (UserGroupInformation)UserGroupInformation.getLoginUser());
                break;
            }
            case TOKEN: {
                proxyUser = UserGroupInformation.createProxyUser((String)proxyUserName, (UserGroupInformation)UserGroupInformation.getLoginUser());
                Optional<Token<?>> proxyToken = ProxiedFileSystemWrapper.getTokenFromSeqFile(authPath, proxyUserName);
                if (proxyToken.isPresent()) {
                    proxyUser.addToken((Token)proxyToken.get());
                    break;
                }
                LOG.warn("No delegation token found for the current proxy user.");
                break;
            }
            default: {
                LOG.warn("Creating a proxy user without authentication, which could not perform File system operations.");
                proxyUser = UserGroupInformation.createProxyUser((String)proxyUserName, (UserGroupInformation)UserGroupInformation.getLoginUser());
            }
        }
        final URI fsURI = URI.create(uri);
        proxyUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws IOException {
                LOG.debug("Now performing file system operations as :" + UserGroupInformation.getCurrentUser());
                ProxiedFileSystemWrapper.this.proxiedFs = FileSystem.get((URI)fsURI, (Configuration)conf);
                return null;
            }
        });
        return this.proxiedFs;
    }

    private static Optional<Token<?>> getTokenFromSeqFile(String authPath, String proxyUserName) throws IOException {
        try (Closer closer = Closer.create();){
            LocalFileSystem localFs = FileSystem.getLocal((Configuration)new Configuration());
            SequenceFile.Reader tokenReader = (SequenceFile.Reader)closer.register((Closeable)new SequenceFile.Reader((FileSystem)localFs, new Path(authPath), localFs.getConf()));
            Text key = new Text();
            Token value = new Token();
            while (tokenReader.next((Writable)key, (Writable)value)) {
                LOG.info("Found token for " + key);
                if (!key.toString().equals(proxyUserName)) continue;
                Optional optional = Optional.of((Object)value);
                return optional;
            }
        }
        return Optional.absent();
    }

    @Deprecated
    public static enum AuthType {
        TOKEN,
        KEYTAB;

    }
}

