/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import com.github.rholder.retry.Retryer;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import org.apache.avro.file.CodecFactory;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.apache.gobblin.util.ForkOperatorUtils;
import org.apache.gobblin.util.HadoopUtils;
import org.apache.gobblin.util.ProxiedFileSystemCache;
import org.apache.gobblin.util.ProxiedFileSystemUtils;
import org.apache.gobblin.util.retry.RetryerFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.token.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriterUtils {
    private static final Logger log = LoggerFactory.getLogger(WriterUtils.class);
    public static final String WRITER_ENCRYPTED_CONFIG_PATH = "writer.encrypted";
    public static final Config NO_RETRY_CONFIG = ConfigFactory.empty();

    public static Path getWriterStagingDir(State state, int numBranches, int branchId) {
        String writerStagingDirKey = ForkOperatorUtils.getPropertyNameForBranch("writer.staging.dir", numBranches, branchId);
        Preconditions.checkArgument((boolean)state.contains(writerStagingDirKey), (Object)("Missing required property " + writerStagingDirKey));
        return new Path(state.getProp(ForkOperatorUtils.getPropertyNameForBranch("writer.staging.dir", numBranches, branchId)), WriterUtils.getWriterFilePath(state, numBranches, branchId));
    }

    public static Path getWriterStagingDir(State state, int numBranches, int branchId, String attemptId) {
        Preconditions.checkArgument((attemptId != null && !attemptId.isEmpty() ? 1 : 0) != 0, (Object)("AttemptId cannot be null or empty: " + attemptId));
        return new Path(WriterUtils.getWriterStagingDir(state, numBranches, branchId), attemptId);
    }

    public static Path getWriterOutputDir(State state, int numBranches, int branchId) {
        String writerOutputDirKey = ForkOperatorUtils.getPropertyNameForBranch("writer.output.dir", numBranches, branchId);
        Preconditions.checkArgument((boolean)state.contains(writerOutputDirKey), (Object)("Missing required property " + writerOutputDirKey));
        return new Path(state.getProp(writerOutputDirKey), WriterUtils.getWriterFilePath(state, numBranches, branchId));
    }

    public static Path getDataPublisherFinalDir(State state, int numBranches, int branchId) {
        String dataPublisherFinalDirKey = ForkOperatorUtils.getPropertyNameForBranch("data.publisher.final.dir", numBranches, branchId);
        Preconditions.checkArgument((boolean)state.contains(dataPublisherFinalDirKey), (Object)("Missing required property " + dataPublisherFinalDirKey));
        if (state.getPropAsBoolean("data.publisher.appendExtractToFinalDir", true)) {
            return new Path(state.getProp(ForkOperatorUtils.getPropertyNameForBranch("data.publisher.final.dir", numBranches, branchId)), WriterUtils.getWriterFilePath(state, numBranches, branchId));
        }
        return new Path(state.getProp(ForkOperatorUtils.getPropertyNameForBranch("data.publisher.final.dir", numBranches, branchId)));
    }

    public static Path getWriterFilePath(State state, int numBranches, int branchId) {
        if (state.contains(ForkOperatorUtils.getPropertyNameForBranch("writer.file.path", numBranches, branchId))) {
            return new Path(state.getProp(ForkOperatorUtils.getPropertyNameForBranch("writer.file.path", numBranches, branchId)));
        }
        switch (WriterUtils.getWriterFilePathType(state)) {
            case NAMESPACE_TABLE: {
                return WriterUtils.getNamespaceTableWriterFilePath(state);
            }
            case TABLENAME: {
                return WriterUtils.getTableNameWriterFilePath(state);
            }
        }
        return WriterUtils.getDefaultWriterFilePath(state, numBranches, branchId);
    }

    private static WriterFilePathType getWriterFilePathType(State state) {
        String pathTypeStr = state.getProp("writer.file.path.type", "default");
        return WriterFilePathType.valueOf(pathTypeStr.toUpperCase());
    }

    public static Path getNamespaceTableWriterFilePath(State state) {
        Preconditions.checkArgument((boolean)state.contains("extract.namespace"));
        Preconditions.checkArgument((boolean)state.contains("extract.table.name"));
        String namespace = state.getProp("extract.namespace").replaceAll("\\.", "/");
        return new Path(namespace + "/" + state.getProp("extract.table.name"));
    }

    public static Path getTableNameWriterFilePath(State state) {
        Preconditions.checkArgument((boolean)state.contains("extract.table.name"));
        return new Path(state.getProp("extract.table.name"));
    }

    public static Path getDefaultWriterFilePath(State state, int numBranches, int branchId) {
        if (state instanceof WorkUnitState) {
            WorkUnitState workUnitState = (WorkUnitState)state;
            return new Path(ForkOperatorUtils.getPathForBranch((State)workUnitState, workUnitState.getOutputFilePath(), numBranches, branchId));
        }
        if (state instanceof WorkUnit) {
            WorkUnit workUnit = (WorkUnit)state;
            return new Path(ForkOperatorUtils.getPathForBranch((State)workUnit, workUnit.getOutputFilePath(), numBranches, branchId));
        }
        throw new RuntimeException("In order to get the default value for writer.file.path the given state must be of type " + WorkUnitState.class.getName() + " or " + WorkUnit.class.getName());
    }

    public static String getWriterFileName(State state, int numBranches, int branchId, String writerId, String formatExtension) {
        String defaultFileName = Strings.isNullOrEmpty((String)formatExtension) ? String.format("%s.%s", "part", writerId) : String.format("%s.%s.%s", "part", writerId, formatExtension);
        return state.getProp(ForkOperatorUtils.getPropertyNameForBranch("writer.file.name", numBranches, branchId), defaultFileName);
    }

    public static CodecFactory getCodecFactory(Optional<String> codecName, Optional<String> deflateLevel) {
        if (!codecName.isPresent()) {
            return CodecFactory.deflateCodec((int)9);
        }
        if (((String)codecName.get()).equalsIgnoreCase("deflate")) {
            if (!deflateLevel.isPresent()) {
                return CodecFactory.deflateCodec((int)9);
            }
            return CodecFactory.deflateCodec((int)Integer.parseInt((String)deflateLevel.get()));
        }
        return CodecFactory.fromString((String)((String)codecName.get()).toLowerCase());
    }

    public static void mkdirsWithRecursivePermission(FileSystem fs, Path path, FsPermission perm) throws IOException {
        WriterUtils.mkdirsWithRecursivePermissionWithRetry(fs, path, perm, NO_RETRY_CONFIG);
    }

    public static void mkdirsWithRecursivePermissionWithRetry(FileSystem fs, Path path, FsPermission perm, Config retrierConfig) throws IOException {
        if (fs.exists(path)) {
            return;
        }
        if (path.getParent() != null && !fs.exists(path.getParent())) {
            WriterUtils.mkdirsWithRecursivePermissionWithRetry(fs, path.getParent(), perm, retrierConfig);
        }
        if (!fs.mkdirs(path, perm)) {
            throw new IOException(String.format("Unable to mkdir %s with permission %s", path, perm));
        }
        if (retrierConfig != NO_RETRY_CONFIG) {
            Retryer retryer = RetryerFactory.newInstance(retrierConfig);
            try {
                retryer.call(() -> {
                    if (!fs.exists(path)) {
                        throw new IOException("Path " + path + " does not exist however it should. Will wait more.");
                    }
                    return null;
                });
            }
            catch (Exception e) {
                throw new IOException("Path " + path + "does not exist however it should. Giving up..." + e);
            }
        }
        if (!fs.getFileStatus(path).getPermission().equals((Object)perm)) {
            fs.setPermission(path, perm);
        }
    }

    public static URI getWriterFsUri(State state, int numBranches, int branchId) {
        return URI.create(state.getProp(ForkOperatorUtils.getPropertyNameForBranch("writer.fs.uri", numBranches, branchId), "file:///"));
    }

    public static FileSystem getWriterFS(State state, int numBranches, int branchId) throws IOException {
        URI uri = WriterUtils.getWriterFsUri(state, numBranches, branchId);
        Configuration hadoopConf = WriterUtils.getFsConfiguration(state);
        if (state.getPropAsBoolean("should.fs.proxy.as.user", false)) {
            String authMethod = state.getProp("fs.proxy.auth.method", "TOKEN");
            if (authMethod.equalsIgnoreCase("TOKEN")) {
                return WriterUtils.getWriterFsUsingToken(state, uri);
            }
            if (authMethod.equalsIgnoreCase("KERBEROS")) {
                return WriterUtils.getWriterFsUsingKeytab(state, uri);
            }
        }
        return FileSystem.get((URI)uri, (Configuration)hadoopConf);
    }

    public static FileSystem getWriterFs(State state) throws IOException {
        return WriterUtils.getWriterFS(state, 1, 0);
    }

    private static FileSystem getWriterFsUsingToken(State state, URI uri) throws IOException {
        try {
            String user = state.getProp("fs.proxy.as.user.name");
            Optional<Token<?>> token = ProxiedFileSystemUtils.getTokenFromSeqFile(user, new Path(state.getProp("fs.proxy.as.user.token.file")));
            if (!token.isPresent()) {
                throw new IOException("No token found for user " + user);
            }
            return ProxiedFileSystemCache.fromToken().userNameToken((Token)token.get()).userNameToProxyAs(state.getProp("fs.proxy.as.user.name")).fsURI(uri).conf(HadoopUtils.newConfiguration()).build();
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
    }

    private static FileSystem getWriterFsUsingKeytab(State state, URI uri) throws IOException {
        FileSystem fs = FileSystem.newInstance((URI)uri, (Configuration)new Configuration());
        try {
            Preconditions.checkArgument((boolean)state.contains("fs.proxy.as.user.name"), (Object)"Missing required property fs.proxy.as.user.name");
            Preconditions.checkArgument((boolean)state.contains("super.user.name.to.proxy.as.others"), (Object)"Missing required property super.user.name.to.proxy.as.others");
            Preconditions.checkArgument((boolean)state.contains("super.user.key.tab.location"), (Object)"Missing required property super.user.key.tab.location");
            String user = state.getProp("fs.proxy.as.user.name");
            String superUser = state.getProp("super.user.name.to.proxy.as.others");
            Path keytabLocation = new Path(state.getProp("super.user.key.tab.location"));
            return ProxiedFileSystemCache.fromKeytab().userNameToProxyAs(user).fsURI(uri).superUserKeytabLocation(keytabLocation).superUserName(superUser).conf(HadoopUtils.newConfiguration()).referenceFS(fs).build();
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
    }

    public static Configuration getFsConfiguration(State state) {
        return HadoopUtils.getConfFromState(state, (Optional<String>)Optional.of((Object)WRITER_ENCRYPTED_CONFIG_PATH));
    }

    public static enum WriterFilePathType {
        NAMESPACE_TABLE,
        TABLENAME,
        DEFAULT;

    }
}

