/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.concurrent;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Iterables;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.util.concurrent.CancellableTask;
import org.apache.gobblin.util.concurrent.ScheduledTask;

public abstract class TaskScheduler<K, T extends ScheduledTask<K>>
implements Closeable {
    private final Object $lock = new Object[0];
    private final Cache<K, CancellableTask<K, T>> cancellableTaskMap = CacheBuilder.newBuilder().build();
    private volatile boolean isStarted = false;

    protected TaskScheduler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void start(Optional<String> name) {
        Object object = this.$lock;
        synchronized (object) {
            if (!this.isStarted) {
                this.startImpl(name);
                this.isStarted = true;
            }
        }
    }

    abstract void startImpl(Optional<String> var1);

    public final void schedule(T task, long period, TimeUnit unit) throws IOException {
        Preconditions.checkArgument((boolean)this.isStarted, (Object)"TaskScheduler is not started");
        try {
            CancellableTask cancellableTask = (CancellableTask)this.cancellableTaskMap.get(task.getKey(), new Callable<CancellableTask<K, T>>((ScheduledTask)task, period, unit){
                final /* synthetic */ ScheduledTask val$task;
                final /* synthetic */ long val$period;
                final /* synthetic */ TimeUnit val$unit;
                {
                    this.val$task = scheduledTask;
                    this.val$period = l;
                    this.val$unit = timeUnit;
                }

                @Override
                public CancellableTask<K, T> call() {
                    return TaskScheduler.this.scheduleImpl(this.val$task, this.val$period, this.val$unit);
                }
            });
            if (cancellableTask.getScheduledTask() != task) {
                throw new IOException("Failed to schedule task with duplicate key");
            }
        }
        catch (ExecutionException e) {
            throw new IOException("Failed to schedule task", e);
        }
    }

    abstract CancellableTask<K, T> scheduleImpl(T var1, long var2, TimeUnit var4);

    public final Iterable<T> getScheduledTasks() {
        return Iterables.transform(this.cancellableTaskMap.asMap().values(), (Function)new Function<CancellableTask<K, T>, T>(){

            public T apply(CancellableTask<K, T> cancellableTask) {
                return cancellableTask.getScheduledTask();
            }
        });
    }

    public final Optional<T> getScheduledTask(K key) {
        CancellableTask cancellableTask = (CancellableTask)this.cancellableTaskMap.getIfPresent(key);
        if (cancellableTask != null) {
            return Optional.of(cancellableTask.getScheduledTask());
        }
        return Optional.absent();
    }

    public boolean cancel(T task) {
        CancellableTask cancellableTask = (CancellableTask)this.cancellableTaskMap.getIfPresent(task.getKey());
        if (cancellableTask != null && cancellableTask.getScheduledTask() == task && cancellableTask.cancel()) {
            this.cancellableTaskMap.invalidate(task.getKey());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        Object object = this.$lock;
        synchronized (object) {
            if (this.isStarted) {
                this.isStarted = false;
                this.closeImpl();
            }
        }
    }

    abstract void closeImpl() throws IOException;
}

