/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.eventbus;

import com.google.common.eventbus.EventBus;
import java.io.IOException;
import org.apache.gobblin.broker.ResourceInstance;
import org.apache.gobblin.broker.iface.ConfigView;
import org.apache.gobblin.broker.iface.NotConfiguredException;
import org.apache.gobblin.broker.iface.ScopeType;
import org.apache.gobblin.broker.iface.ScopedConfigView;
import org.apache.gobblin.broker.iface.SharedResourceFactory;
import org.apache.gobblin.broker.iface.SharedResourceFactoryResponse;
import org.apache.gobblin.broker.iface.SharedResourceKey;
import org.apache.gobblin.broker.iface.SharedResourcesBroker;
import org.apache.gobblin.util.eventbus.EventBusKey;

public class EventBusFactory<S extends ScopeType<S>>
implements SharedResourceFactory<EventBus, EventBusKey, S> {
    public static final String FACTORY_NAME = "eventbus";

    public String getName() {
        return FACTORY_NAME;
    }

    public static <S extends ScopeType<S>> EventBus get(String eventBusName, SharedResourcesBroker<S> broker) throws IOException {
        try {
            return (EventBus)broker.getSharedResource(new EventBusFactory<S>(), (SharedResourceKey)new EventBusKey(eventBusName));
        }
        catch (NotConfiguredException e) {
            throw new IOException(e);
        }
    }

    public SharedResourceFactoryResponse<EventBus> createResource(SharedResourcesBroker<S> broker, ScopedConfigView<S, EventBusKey> config) {
        EventBusKey eventBusKey = (EventBusKey)config.getKey();
        EventBus eventBus = new EventBus(eventBusKey.getSourceClassName());
        return new ResourceInstance<EventBus>(eventBus);
    }

    public S getAutoScope(SharedResourcesBroker<S> broker, ConfigView<S, EventBusKey> config) {
        return (S)broker.selfScope().getType().rootScope();
    }
}

