/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.executors;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.gobblin.util.Either;
import org.apache.gobblin.util.ExecutorsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IteratorExecutor<T> {
    private static final Logger log = LoggerFactory.getLogger(IteratorExecutor.class);
    private final CompletionService<T> completionService;
    private final int numThreads;
    private final ExecutorService executor;
    private final Iterator<Callable<T>> iterator;
    private boolean executed;

    public IteratorExecutor(Iterator<Callable<T>> runnableIterator, int numThreads, ThreadFactory threadFactory) {
        this.numThreads = numThreads;
        this.iterator = runnableIterator;
        this.executor = ExecutorsUtils.loggingDecorator(Executors.newFixedThreadPool(numThreads, threadFactory));
        this.completionService = new ExecutorCompletionService<T>(this.executor);
        this.executed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Future<T>> execute() throws InterruptedException {
        ArrayList futures = Lists.newArrayList();
        try {
            if (this.executed) {
                throw new RuntimeException(String.format("This %s has already been executed.", IteratorExecutor.class.getSimpleName()));
            }
            int activeTasks = 0;
            while (this.iterator.hasNext()) {
                try {
                    futures.add(this.completionService.submit(this.iterator.next()));
                    ++activeTasks;
                }
                catch (Exception exception) {
                    futures.add(Futures.immediateFailedFuture((Throwable)exception));
                }
                if (activeTasks != this.numThreads) continue;
                this.completionService.take();
                --activeTasks;
            }
            while (activeTasks > 0) {
                this.completionService.take();
                --activeTasks;
            }
        }
        finally {
            ExecutorsUtils.shutdownExecutorService(this.executor, (Optional<Logger>)Optional.of((Object)log), 10L, TimeUnit.SECONDS);
            this.executed = true;
        }
        return futures;
    }

    public List<Either<T, ExecutionException>> executeAndGetResults() throws InterruptedException {
        ArrayList results = Lists.newArrayList();
        List<Future<T>> futures = this.execute();
        for (Future<T> future : futures) {
            try {
                results.add(Either.left(future.get()));
            }
            catch (ExecutionException ee) {
                results.add(Either.right(ee));
            }
        }
        return results;
    }

    public static <T> boolean verifyAllSuccessful(List<Either<T, ExecutionException>> results) {
        return Iterables.all(results, (Predicate)new Predicate<Either<T, ExecutionException>>(){

            public boolean apply(@Nullable Either<T, ExecutionException> input) {
                return input instanceof Either.Left;
            }
        });
    }

    public static <T> void logFailures(List<Either<T, ExecutionException>> results, Logger useLogger, int atMost) {
        Logger actualLogger = useLogger == null ? log : useLogger;
        Iterator<Either<T, ExecutionException>> it = results.iterator();
        int printed = 0;
        while (it.hasNext()) {
            Either<T, ExecutionException> nextResult = it.next();
            if (!(nextResult instanceof Either.Right)) continue;
            ExecutionException exc = (ExecutionException)((Either.Right)nextResult).getRight();
            actualLogger.error("Iterator executor failure.", (Throwable)exc);
            if (++printed < atMost) continue;
            return;
        }
    }

    public static <T> void logAndThrowFailures(List<Either<T, ExecutionException>> results, Logger useLogger, int atMost) {
        Logger actualLogger = useLogger == null ? log : useLogger;
        Iterator<Either<T, ExecutionException>> it = results.iterator();
        int printed = 0;
        ExecutionException exc = null;
        while (it.hasNext()) {
            Either<T, ExecutionException> nextResult = it.next();
            if (!(nextResult instanceof Either.Right)) continue;
            exc = (ExecutionException)((Either.Right)nextResult).getRight();
            actualLogger.error("Iterator executor failure.", (Throwable)exc);
            if (++printed < atMost) continue;
            break;
        }
        if (printed > 0) {
            throw new RuntimeException(exc);
        }
    }
}

