/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.filesystem;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.EnumSet;
import org.apache.gobblin.util.Decorator;
import org.apache.gobblin.util.filesystem.InstrumentedFileSystemUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Progressable;

class FileSystemDecorator
extends FileSystem
implements Decorator {
    protected String replacementScheme;
    protected String underlyingScheme;
    protected Configuration conf;
    protected FileSystem underlyingFs;

    FileSystemDecorator(String replacementScheme, String underlyingScheme) {
        this.replacementScheme = replacementScheme;
        this.underlyingScheme = underlyingScheme;
    }

    public Object getDecoratedObject() {
        return this.underlyingFs;
    }

    public String getScheme() {
        return this.replacementScheme;
    }

    public void initialize(URI uri, Configuration conf) throws IOException {
        if (this.underlyingFs == null) {
            throw new IllegalStateException("Underlying fs has not been defined.");
        }
        this.underlyingFs.initialize(InstrumentedFileSystemUtils.replaceScheme(uri, this.replacementScheme, this.underlyingScheme), conf);
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        if (this.underlyingFs != null) {
            this.underlyingFs.setConf(conf);
        }
    }

    public URI getUri() {
        return InstrumentedFileSystemUtils.replaceScheme(this.underlyingFs.getUri(), this.underlyingScheme, this.replacementScheme);
    }

    public FileStatus getFileLinkStatus(Path f) throws IOException {
        return InstrumentedFileSystemUtils.replaceScheme(this.underlyingFs.getFileLinkStatus(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme)), this.underlyingScheme, this.replacementScheme);
    }

    public FsStatus getStatus() throws IOException {
        return this.underlyingFs.getStatus();
    }

    public FSDataOutputStream append(Path f) throws IOException {
        return this.underlyingFs.append(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme));
    }

    public short getReplication(Path src) throws IOException {
        return this.underlyingFs.getReplication(InstrumentedFileSystemUtils.replaceScheme(src, this.replacementScheme, this.underlyingScheme));
    }

    public void close() throws IOException {
        this.underlyingFs.close();
    }

    public void setWriteChecksum(boolean writeChecksum) {
        this.underlyingFs.setWriteChecksum(writeChecksum);
    }

    public FileChecksum getFileChecksum(Path f) throws IOException {
        return this.underlyingFs.getFileChecksum(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme));
    }

    public boolean isDirectory(Path f) throws IOException {
        return this.underlyingFs.isDirectory(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme));
    }

    public void createSymlink(Path target, Path link, boolean createParent) throws IOException {
        this.underlyingFs.createSymlink(InstrumentedFileSystemUtils.replaceScheme(target, this.replacementScheme, this.underlyingScheme), InstrumentedFileSystemUtils.replaceScheme(link, this.replacementScheme, this.underlyingScheme), createParent);
    }

    public Path createSnapshot(Path path, String snapshotName) throws IOException {
        return InstrumentedFileSystemUtils.replaceScheme(this.underlyingFs.createSnapshot(InstrumentedFileSystemUtils.replaceScheme(path, this.replacementScheme, this.underlyingScheme), snapshotName), this.underlyingScheme, this.replacementScheme);
    }

    public FSDataOutputStream create(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt) throws IOException {
        return this.underlyingFs.create(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme), permission, flags, bufferSize, replication, blockSize, progress, checksumOpt);
    }

    public Path resolvePath(Path p) throws IOException {
        return InstrumentedFileSystemUtils.replaceScheme(this.underlyingFs.resolvePath(InstrumentedFileSystemUtils.replaceScheme(p, this.replacementScheme, this.underlyingScheme)), this.underlyingScheme, this.replacementScheme);
    }

    public FileStatus[] listStatus(Path f) throws FileNotFoundException, IOException {
        return InstrumentedFileSystemUtils.replaceScheme(this.underlyingFs.listStatus(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme)), this.underlyingScheme, this.replacementScheme);
    }

    public long getUsed() throws IOException {
        return this.underlyingFs.getUsed();
    }

    public Configuration getConf() {
        return this.underlyingFs.getConf();
    }

    public FSDataOutputStream create(Path f, Progressable progress) throws IOException {
        return this.underlyingFs.create(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme), progress);
    }

    public boolean isFile(Path f) throws IOException {
        return this.underlyingFs.isFile(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme));
    }

    public Path getWorkingDirectory() {
        return InstrumentedFileSystemUtils.replaceScheme(this.underlyingFs.getWorkingDirectory(), this.underlyingScheme, this.replacementScheme);
    }

    public FsServerDefaults getServerDefaults() throws IOException {
        return this.underlyingFs.getServerDefaults();
    }

    public void copyToLocalFile(boolean delSrc, Path src, Path dst, boolean useRawLocalFileSystem) throws IOException {
        this.underlyingFs.copyToLocalFile(delSrc, InstrumentedFileSystemUtils.replaceScheme(src, this.replacementScheme, this.underlyingScheme), InstrumentedFileSystemUtils.replaceScheme(dst, this.replacementScheme, this.underlyingScheme), useRawLocalFileSystem);
    }

    public FileStatus[] globStatus(Path pathPattern) throws IOException {
        return InstrumentedFileSystemUtils.replaceScheme(this.underlyingFs.globStatus(InstrumentedFileSystemUtils.replaceScheme(pathPattern, this.replacementScheme, this.underlyingScheme)), this.underlyingScheme, this.replacementScheme);
    }

    public void setWorkingDirectory(Path new_dir) {
        this.underlyingFs.setWorkingDirectory(InstrumentedFileSystemUtils.replaceScheme(new_dir, this.replacementScheme, this.underlyingScheme));
    }

    public FileStatus[] listStatus(Path f, PathFilter filter) throws IOException {
        return InstrumentedFileSystemUtils.replaceScheme(this.underlyingFs.listStatus(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme), filter), this.underlyingScheme, this.replacementScheme);
    }

    public String getName() {
        return this.underlyingFs.getName();
    }

    public boolean createNewFile(Path f) throws IOException {
        return this.underlyingFs.createNewFile(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme));
    }

    public FileStatus[] listStatus(Path[] files) throws IOException {
        return InstrumentedFileSystemUtils.replaceScheme(this.underlyingFs.listStatus(InstrumentedFileSystemUtils.replaceScheme(files, this.replacementScheme, this.underlyingScheme)), this.underlyingScheme, this.replacementScheme);
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        return this.underlyingFs.delete(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme), recursive);
    }

    public Path getLinkTarget(Path f) throws IOException {
        return InstrumentedFileSystemUtils.replaceScheme(this.underlyingFs.getLinkTarget(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme)), this.underlyingScheme, this.replacementScheme);
    }

    public void copyToLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        this.underlyingFs.copyToLocalFile(delSrc, InstrumentedFileSystemUtils.replaceScheme(src, this.replacementScheme, this.underlyingScheme), InstrumentedFileSystemUtils.replaceScheme(dst, this.replacementScheme, this.underlyingScheme));
    }

    public short getDefaultReplication() {
        return this.underlyingFs.getDefaultReplication();
    }

    public Token<?> getDelegationToken(String renewer) throws IOException {
        return this.underlyingFs.getDelegationToken(renewer);
    }

    public FsServerDefaults getServerDefaults(Path p) throws IOException {
        return this.underlyingFs.getServerDefaults(InstrumentedFileSystemUtils.replaceScheme(p, this.replacementScheme, this.underlyingScheme));
    }

    public FSDataOutputStream create(Path f, short replication) throws IOException {
        return this.underlyingFs.create(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme), replication);
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        return this.underlyingFs.mkdirs(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme), permission);
    }

    public BlockLocation[] getFileBlockLocations(Path p, long start, long len) throws IOException {
        return this.underlyingFs.getFileBlockLocations(InstrumentedFileSystemUtils.replaceScheme(p, this.replacementScheme, this.underlyingScheme), start, len);
    }

    public void concat(Path trg, Path[] psrcs) throws IOException {
        this.underlyingFs.concat(InstrumentedFileSystemUtils.replaceScheme(trg, this.replacementScheme, this.underlyingScheme), InstrumentedFileSystemUtils.replaceScheme(psrcs, this.replacementScheme, this.underlyingScheme));
    }

    public Path getHomeDirectory() {
        return InstrumentedFileSystemUtils.replaceScheme(this.underlyingFs.getHomeDirectory(), this.underlyingScheme, this.replacementScheme);
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        return InstrumentedFileSystemUtils.replaceScheme(this.underlyingFs.getFileStatus(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme)), this.underlyingScheme, this.replacementScheme);
    }

    public boolean supportsSymlinks() {
        return this.underlyingFs.supportsSymlinks();
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f) throws FileNotFoundException, IOException {
        return this.underlyingFs.listLocatedStatus(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme));
    }

    public RemoteIterator<Path> listCorruptFileBlocks(Path path) throws IOException {
        return this.underlyingFs.listCorruptFileBlocks(InstrumentedFileSystemUtils.replaceScheme(path, this.replacementScheme, this.underlyingScheme));
    }

    public FSDataOutputStream create(Path f, short replication, Progressable progress) throws IOException {
        return this.underlyingFs.create(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme), replication, progress);
    }

    public boolean setReplication(Path src, short replication) throws IOException {
        return this.underlyingFs.setReplication(InstrumentedFileSystemUtils.replaceScheme(src, this.replacementScheme, this.underlyingScheme), replication);
    }

    public Path makeQualified(Path path) {
        return InstrumentedFileSystemUtils.replaceScheme(this.underlyingFs.makeQualified(InstrumentedFileSystemUtils.replaceScheme(path, this.replacementScheme, this.underlyingScheme)), this.underlyingScheme, this.replacementScheme);
    }

    public FSDataOutputStream createNonRecursive(Path f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.underlyingFs.createNonRecursive(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme), overwrite, bufferSize, replication, blockSize, progress);
    }

    public long getBlockSize(Path f) throws IOException {
        return this.underlyingFs.getBlockSize(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme));
    }

    public short getDefaultReplication(Path path) {
        return this.underlyingFs.getDefaultReplication(InstrumentedFileSystemUtils.replaceScheme(path, this.replacementScheme, this.underlyingScheme));
    }

    public Token<?>[] addDelegationTokens(String renewer, Credentials credentials) throws IOException {
        return this.underlyingFs.addDelegationTokens(renewer, credentials);
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.underlyingFs.create(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme), overwrite, bufferSize, replication, blockSize, progress);
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        return this.underlyingFs.append(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme), bufferSize, progress);
    }

    public void copyToLocalFile(Path src, Path dst) throws IOException {
        this.underlyingFs.copyToLocalFile(InstrumentedFileSystemUtils.replaceScheme(src, this.replacementScheme, this.underlyingScheme), InstrumentedFileSystemUtils.replaceScheme(dst, this.replacementScheme, this.underlyingScheme));
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        return this.underlyingFs.open(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme), bufferSize);
    }

    public FileStatus[] listStatus(Path[] files, PathFilter filter) throws IOException {
        return InstrumentedFileSystemUtils.replaceScheme(this.underlyingFs.listStatus(InstrumentedFileSystemUtils.replaceScheme(files, this.replacementScheme, this.underlyingScheme), filter), this.underlyingScheme, this.replacementScheme);
    }

    public long getLength(Path f) throws IOException {
        return this.underlyingFs.getLength(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme));
    }

    public void moveToLocalFile(Path src, Path dst) throws IOException {
        this.underlyingFs.moveToLocalFile(InstrumentedFileSystemUtils.replaceScheme(src, this.replacementScheme, this.underlyingScheme), InstrumentedFileSystemUtils.replaceScheme(dst, this.replacementScheme, this.underlyingScheme));
    }

    public FsStatus getStatus(Path p) throws IOException {
        return this.underlyingFs.getStatus(InstrumentedFileSystemUtils.replaceScheme(p, this.replacementScheme, this.underlyingScheme));
    }

    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.underlyingFs.createNonRecursive(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme), permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    public String getCanonicalServiceName() {
        return this.underlyingFs.getCanonicalServiceName();
    }

    public boolean cancelDeleteOnExit(Path f) {
        return this.underlyingFs.cancelDeleteOnExit(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme));
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path[] srcs, Path dst) throws IOException {
        this.underlyingFs.copyFromLocalFile(delSrc, overwrite, InstrumentedFileSystemUtils.replaceScheme(srcs, this.replacementScheme, this.underlyingScheme), InstrumentedFileSystemUtils.replaceScheme(dst, this.replacementScheme, this.underlyingScheme));
    }

    public void setPermission(Path p, FsPermission permission) throws IOException {
        this.underlyingFs.setPermission(InstrumentedFileSystemUtils.replaceScheme(p, this.replacementScheme, this.underlyingScheme), permission);
    }

    public Path startLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        return InstrumentedFileSystemUtils.replaceScheme(this.underlyingFs.startLocalOutput(InstrumentedFileSystemUtils.replaceScheme(fsOutputFile, this.replacementScheme, this.underlyingScheme), InstrumentedFileSystemUtils.replaceScheme(tmpLocalFile, this.replacementScheme, this.underlyingScheme)), this.underlyingScheme, this.replacementScheme);
    }

    public void copyFromLocalFile(Path src, Path dst) throws IOException {
        this.underlyingFs.copyFromLocalFile(InstrumentedFileSystemUtils.replaceScheme(src, this.replacementScheme, this.underlyingScheme), InstrumentedFileSystemUtils.replaceScheme(dst, this.replacementScheme, this.underlyingScheme));
    }

    public boolean delete(Path f) throws IOException {
        return this.underlyingFs.delete(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme));
    }

    public FileSystem[] getChildFileSystems() {
        return this.underlyingFs.getChildFileSystems();
    }

    public void copyFromLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        this.underlyingFs.copyFromLocalFile(delSrc, InstrumentedFileSystemUtils.replaceScheme(src, this.replacementScheme, this.underlyingScheme), InstrumentedFileSystemUtils.replaceScheme(dst, this.replacementScheme, this.underlyingScheme));
    }

    public void setTimes(Path p, long mtime, long atime) throws IOException {
        this.underlyingFs.setTimes(InstrumentedFileSystemUtils.replaceScheme(p, this.replacementScheme, this.underlyingScheme), mtime, atime);
    }

    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        return this.underlyingFs.getFileBlockLocations(InstrumentedFileSystemUtils.replaceScheme(file, this.replacementScheme, this.underlyingScheme), start, len);
    }

    public ContentSummary getContentSummary(Path f) throws IOException {
        return this.underlyingFs.getContentSummary(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme));
    }

    public void renameSnapshot(Path path, String snapshotOldName, String snapshotNewName) throws IOException {
        this.underlyingFs.renameSnapshot(InstrumentedFileSystemUtils.replaceScheme(path, this.replacementScheme, this.underlyingScheme), snapshotOldName, snapshotNewName);
    }

    public void moveFromLocalFile(Path[] srcs, Path dst) throws IOException {
        this.underlyingFs.moveFromLocalFile(InstrumentedFileSystemUtils.replaceScheme(srcs, this.replacementScheme, this.underlyingScheme), InstrumentedFileSystemUtils.replaceScheme(dst, this.replacementScheme, this.underlyingScheme));
    }

    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.underlyingFs.createNonRecursive(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme), permission, flags, bufferSize, replication, blockSize, progress);
    }

    public boolean rename(Path src, Path dst) throws IOException {
        return this.underlyingFs.rename(InstrumentedFileSystemUtils.replaceScheme(src, this.replacementScheme, this.underlyingScheme), InstrumentedFileSystemUtils.replaceScheme(dst, this.replacementScheme, this.underlyingScheme));
    }

    public FSDataOutputStream create(Path f) throws IOException {
        return this.underlyingFs.create(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme));
    }

    public boolean mkdirs(Path f) throws IOException {
        return this.underlyingFs.mkdirs(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme));
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize) throws IOException {
        return this.underlyingFs.create(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme), overwrite, bufferSize, replication, blockSize);
    }

    public void completeLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        this.underlyingFs.completeLocalOutput(InstrumentedFileSystemUtils.replaceScheme(fsOutputFile, this.replacementScheme, this.underlyingScheme), InstrumentedFileSystemUtils.replaceScheme(tmpLocalFile, this.replacementScheme, this.underlyingScheme));
    }

    public FSDataInputStream open(Path f) throws IOException {
        return this.underlyingFs.open(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme));
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, Progressable progress) throws IOException {
        return this.underlyingFs.create(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme), overwrite, bufferSize, progress);
    }

    public void setVerifyChecksum(boolean verifyChecksum) {
        this.underlyingFs.setVerifyChecksum(verifyChecksum);
    }

    public FSDataOutputStream create(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.underlyingFs.create(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme), permission, flags, bufferSize, replication, blockSize, progress);
    }

    public long getDefaultBlockSize() {
        return this.underlyingFs.getDefaultBlockSize();
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path src, Path dst) throws IOException {
        this.underlyingFs.copyFromLocalFile(delSrc, overwrite, InstrumentedFileSystemUtils.replaceScheme(src, this.replacementScheme, this.underlyingScheme), InstrumentedFileSystemUtils.replaceScheme(dst, this.replacementScheme, this.underlyingScheme));
    }

    public FSDataOutputStream create(Path f, boolean overwrite) throws IOException {
        return this.underlyingFs.create(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme), overwrite);
    }

    public long getDefaultBlockSize(Path f) {
        return this.underlyingFs.getDefaultBlockSize(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme));
    }

    public boolean exists(Path f) throws IOException {
        return this.underlyingFs.exists(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme));
    }

    public void deleteSnapshot(Path path, String snapshotName) throws IOException {
        this.underlyingFs.deleteSnapshot(InstrumentedFileSystemUtils.replaceScheme(path, this.replacementScheme, this.underlyingScheme), snapshotName);
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize) throws IOException {
        return this.underlyingFs.create(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme), overwrite, bufferSize);
    }

    public void setOwner(Path p, String username, String groupname) throws IOException {
        this.underlyingFs.setOwner(InstrumentedFileSystemUtils.replaceScheme(p, this.replacementScheme, this.underlyingScheme), username, groupname);
    }

    public RemoteIterator<LocatedFileStatus> listFiles(Path f, boolean recursive) throws IOException {
        return this.underlyingFs.listFiles(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme), recursive);
    }

    public FSDataOutputStream append(Path f, int bufferSize) throws IOException {
        return this.underlyingFs.append(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme), bufferSize);
    }

    public boolean deleteOnExit(Path f) throws IOException {
        return this.underlyingFs.deleteOnExit(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme));
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.underlyingFs.create(InstrumentedFileSystemUtils.replaceScheme(f, this.replacementScheme, this.underlyingScheme), permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    public void moveFromLocalFile(Path src, Path dst) throws IOException {
        this.underlyingFs.moveFromLocalFile(InstrumentedFileSystemUtils.replaceScheme(src, this.replacementScheme, this.underlyingScheme), InstrumentedFileSystemUtils.replaceScheme(dst, this.replacementScheme, this.underlyingScheme));
    }

    public FileStatus[] globStatus(Path pathPattern, PathFilter filter) throws IOException {
        return InstrumentedFileSystemUtils.replaceScheme(this.underlyingFs.globStatus(InstrumentedFileSystemUtils.replaceScheme(pathPattern, this.replacementScheme, this.underlyingScheme), filter), this.underlyingScheme, this.replacementScheme);
    }
}

