/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.filesystem;

import java.io.IOException;
import java.net.URI;
import org.apache.gobblin.broker.SharedResourcesBrokerFactory;
import org.apache.gobblin.util.filesystem.FileSystemDecorator;
import org.apache.gobblin.util.filesystem.FileSystemFactory;
import org.apache.gobblin.util.filesystem.InstrumentedFileSystemUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;

public class InstrumentedFileSystem
extends FileSystemDecorator {
    public InstrumentedFileSystem(String scheme, FileSystem underlyingFileSystem) {
        super(scheme, underlyingFileSystem.getScheme());
        this.underlyingFs = underlyingFileSystem;
    }

    @Override
    public void initialize(URI uri, Configuration conf) throws IOException {
        this.replacementScheme = uri.getScheme();
        Configuration actualConfiguration = new Configuration(conf);
        String key = "fs." + this.underlyingScheme + ".impl";
        actualConfiguration.set(key, this.underlyingFs.getClass().getName());
        this.underlyingFs = FileSystemFactory.get(InstrumentedFileSystemUtils.replaceScheme(uri, this.replacementScheme, this.underlyingScheme), actualConfiguration, SharedResourcesBrokerFactory.getImplicitBroker());
    }
}

