/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.io;

import com.google.common.base.Joiner;
import java.net.URI;
import org.apache.gobblin.util.ClustersNames;
import org.apache.gobblin.util.limiter.broker.SharedLimiterKey;
import org.apache.hadoop.fs.LocalFileSystem;

public class StreamCopierSharedLimiterKey
extends SharedLimiterKey {
    public static final String STREAM_COPIER_KEY_PREFIX = "streamCopierBandwidth";
    private final URI sourceURI;
    private final URI targetURI;

    public StreamCopierSharedLimiterKey(URI sourceURI, URI targetURI) {
        super(StreamCopierSharedLimiterKey.getLimitedResourceId(sourceURI, targetURI));
        this.sourceURI = sourceURI;
        this.targetURI = targetURI;
    }

    private static String getLimitedResourceId(URI sourceURI, URI targetURI) {
        return Joiner.on((String)"/").join((Object)STREAM_COPIER_KEY_PREFIX, (Object)StreamCopierSharedLimiterKey.getFSIdentifier(sourceURI), new Object[]{StreamCopierSharedLimiterKey.getFSIdentifier(targetURI)});
    }

    private static String getFSIdentifier(URI uri) {
        if (new LocalFileSystem().getScheme().equals(uri.getScheme())) {
            return "localhost";
        }
        return ClustersNames.getInstance().getClusterName(uri.toString());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StreamCopierSharedLimiterKey that = (StreamCopierSharedLimiterKey)o;
        if (!this.sourceURI.equals(that.sourceURI)) {
            return false;
        }
        return this.targetURI.equals(that.targetURI);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.sourceURI.hashCode();
        result = 31 * result + this.targetURI.hashCode();
        return result;
    }

    public URI getSourceURI() {
        return this.sourceURI;
    }

    public URI getTargetURI() {
        return this.targetURI;
    }
}

