/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.limiter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.gobblin.util.limiter.Limiter;
import org.apache.gobblin.util.limiter.NoopLimiter;

public class MultiLimiter
implements Limiter {
    private final ImmutableList<Limiter> underlyingLimiters;

    public MultiLimiter(Limiter ... underlyingLimiters) {
        ImmutableList.Builder builder = ImmutableList.builder();
        HashSet seenLimiters = Sets.newHashSet();
        for (Limiter limiter : underlyingLimiters) {
            if (limiter instanceof MultiLimiter) {
                for (Limiter innerLimiter : ((MultiLimiter)limiter).underlyingLimiters) {
                    this.addLimiterIfNotSeen(innerLimiter, (ImmutableList.Builder<Limiter>)builder, seenLimiters);
                }
                continue;
            }
            if (limiter instanceof NoopLimiter) continue;
            this.addLimiterIfNotSeen(limiter, (ImmutableList.Builder<Limiter>)builder, seenLimiters);
        }
        this.underlyingLimiters = builder.build();
    }

    private void addLimiterIfNotSeen(Limiter limiter, ImmutableList.Builder<Limiter> builder, Set<Limiter> seenLimiters) {
        if (!seenLimiters.contains(limiter)) {
            builder.add((Object)limiter);
            seenLimiters.add(limiter);
        }
    }

    @Override
    public void start() {
        for (Limiter limiter : this.underlyingLimiters) {
            limiter.start();
        }
    }

    @Override
    public Closeable acquirePermits(long permits) throws InterruptedException {
        Closer closer = Closer.create();
        for (Limiter limiter : this.underlyingLimiters) {
            Closeable permit = limiter.acquirePermits(permits);
            if (permit == null) {
                try {
                    closer.close();
                }
                catch (IOException ioe) {
                    throw new RuntimeException("Could not return intermediate permits.");
                }
                return null;
            }
            closer.register(permit);
        }
        return closer;
    }

    @Override
    public void stop() {
        for (Limiter limiter : this.underlyingLimiters) {
            limiter.stop();
        }
    }

    public ImmutableList<Limiter> getUnderlyingLimiters() {
        return this.underlyingLimiters;
    }
}

