/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.limiter;

import com.google.common.primitives.Ints;
import com.typesafe.config.Config;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Semaphore;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.util.limiter.Limiter;
import org.apache.gobblin.util.limiter.LimiterFactory;

public class PoolBasedLimiter
implements Limiter {
    private final Semaphore permitPool;

    public PoolBasedLimiter(int poolSize) {
        this.permitPool = new Semaphore(poolSize);
    }

    @Override
    public void start() {
    }

    @Override
    public Closeable acquirePermits(long permits) throws InterruptedException {
        int permitsToAcquire = Ints.checkedCast((long)permits);
        this.permitPool.acquire(permitsToAcquire);
        return new PoolPermitCloseable(this.permitPool, permitsToAcquire);
    }

    @Override
    public void stop() {
    }

    private static class PoolPermitCloseable
    implements Closeable {
        private final Semaphore permitPool;
        private final int permits;

        public PoolPermitCloseable(Semaphore permitPool, int permits) {
            this.permitPool = permitPool;
            this.permits = permits;
        }

        @Override
        public void close() throws IOException {
            this.permitPool.release(this.permits);
        }
    }

    @Alias(value="PoolBasedLimiter")
    public static class Factory
    implements LimiterFactory {
        public static final String POOL_SIZE_KEY = "poolSize";

        @Override
        public Limiter buildLimiter(Config config) {
            if (!config.hasPath(POOL_SIZE_KEY)) {
                throw new IllegalArgumentException("Missing key poolSize");
            }
            return new PoolBasedLimiter(config.getInt(POOL_SIZE_KEY));
        }
    }
}

