/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.request_allocation;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.apache.gobblin.util.iterators.InterruptibleIterator;
import org.apache.gobblin.util.request_allocation.ConcurrentBoundedPriorityIterable;
import org.apache.gobblin.util.request_allocation.PriorityIterableBasedRequestAllocator;
import org.apache.gobblin.util.request_allocation.Request;
import org.apache.gobblin.util.request_allocation.RequestAllocator;
import org.apache.gobblin.util.request_allocation.RequestAllocatorConfig;
import org.apache.gobblin.util.request_allocation.Requestor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreedyAllocator<T extends Request<T>>
extends PriorityIterableBasedRequestAllocator<T> {
    private static final Logger log = LoggerFactory.getLogger(GreedyAllocator.class);

    public GreedyAllocator(RequestAllocatorConfig<T> configuration) {
        super(log, configuration);
    }

    @Override
    protected Iterator<T> getJoinIterator(Iterator<? extends Requestor<T>> requestors, final ConcurrentBoundedPriorityIterable<T> requestIterable) {
        Iterator unionIterator = Iterators.concat((Iterator)Iterators.transform(requestors, (Function)new Function<Requestor<T>, Iterator<T>>(){

            @Nullable
            public Iterator<T> apply(Requestor<T> input) {
                return input.iterator();
            }
        }));
        return new InterruptibleIterator(unionIterator, new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return requestIterable.isFull();
            }
        });
    }

    public static class Factory
    implements RequestAllocator.Factory {
        @Override
        public <T extends Request<T>> RequestAllocator<T> createRequestAllocator(RequestAllocatorConfig<T> configuration) {
            return new GreedyAllocator<T>(configuration);
        }
    }
}

