/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.request_allocation;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.Callable;
import org.apache.gobblin.util.iterators.InterruptibleIterator;
import org.apache.gobblin.util.request_allocation.ConcurrentBoundedPriorityIterable;
import org.apache.gobblin.util.request_allocation.PriorityIterableBasedRequestAllocator;
import org.apache.gobblin.util.request_allocation.PriorityMultiIterator;
import org.apache.gobblin.util.request_allocation.PushDownRequestor;
import org.apache.gobblin.util.request_allocation.Request;
import org.apache.gobblin.util.request_allocation.RequestAllocator;
import org.apache.gobblin.util.request_allocation.RequestAllocatorConfig;
import org.apache.gobblin.util.request_allocation.Requestor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreOrderAllocator<T extends Request<T>>
extends PriorityIterableBasedRequestAllocator<T> {
    private static final Logger log = LoggerFactory.getLogger(PreOrderAllocator.class);

    public PreOrderAllocator(RequestAllocatorConfig<T> configuration) {
        super(log, configuration);
    }

    @Override
    protected Iterator<T> getJoinIterator(Iterator<? extends Requestor<T>> requestors, final ConcurrentBoundedPriorityIterable<T> requestIterable) {
        ArrayList iteratorList = Lists.newArrayList();
        while (requestors.hasNext()) {
            Requestor<T> requestor = requestors.next();
            if (!(requestor instanceof PushDownRequestor)) {
                throw new RuntimeException(String.format("%s can only be used with %s.", PreOrderAllocator.class, PushDownRequestor.class));
            }
            try {
                iteratorList.add(((PushDownRequestor)requestor).getRequests(this.getConfiguration().getPrioritizer()));
            }
            catch (IOException ioe) {
                log.error("Failed to get requests from " + requestor);
            }
        }
        PriorityMultiIterator multiIterator = new PriorityMultiIterator(iteratorList, this.getConfiguration().getPrioritizer());
        return new InterruptibleIterator(multiIterator, new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return requestIterable.isFull();
            }
        });
    }

    public static class Factory
    implements RequestAllocator.Factory {
        @Override
        public <T extends Request<T>> RequestAllocator<T> createRequestAllocator(RequestAllocatorConfig<T> configuration) {
            return new PreOrderAllocator<T>(configuration);
        }
    }
}

