/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.request_allocation;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.Serializable;
import java.util.Comparator;
import org.apache.gobblin.util.request_allocation.Request;
import org.apache.gobblin.util.request_allocation.ResourceEstimator;

public class RequestAllocatorConfig<T extends Request<T>> {
    private final Comparator<T> prioritizer;
    private final ResourceEstimator<T> resourceEstimator;
    private final int allowedThreads;
    private Config limitedScopeConfig;
    private String storeRejectedRequestsSetting;

    public static <T extends Request<T>> Builder<T> builder(ResourceEstimator<T> resourceEstimator) {
        return new Builder<T>(resourceEstimator);
    }

    public RequestAllocatorConfig(Comparator<T> prioritizer, ResourceEstimator<T> resourceEstimator, int allowedThreads, Config limitedScopeConfig, String storeRejectedRequestsSetting) {
        this.prioritizer = prioritizer;
        this.resourceEstimator = resourceEstimator;
        this.allowedThreads = allowedThreads;
        this.limitedScopeConfig = limitedScopeConfig;
        this.storeRejectedRequestsSetting = storeRejectedRequestsSetting;
    }

    public Comparator<T> getPrioritizer() {
        return this.prioritizer;
    }

    public ResourceEstimator<T> getResourceEstimator() {
        return this.resourceEstimator;
    }

    public int getAllowedThreads() {
        return this.allowedThreads;
    }

    public Config getLimitedScopeConfig() {
        return this.limitedScopeConfig;
    }

    public String getStoreRejectedRequestsSetting() {
        return this.storeRejectedRequestsSetting;
    }

    public static class AllEqualPrioritizer<T>
    implements Comparator<T>,
    Serializable {
        @Override
        public int compare(T o1, T o2) {
            return 0;
        }
    }

    public static class Builder<T extends Request<T>> {
        private Comparator<T> prioritizer = new AllEqualPrioritizer();
        private final ResourceEstimator<T> resourceEstimator;
        private int allowedThreads = 1;
        private Config limitedScopeConfig;
        private String storeRejectedRequestsSetting = StoreRejectedRequestsConfig.MIN.name();

        public Builder(ResourceEstimator<T> resourceEstimator) {
            this.resourceEstimator = resourceEstimator;
        }

        public Builder<T> allowParallelization() {
            return this.allowParallelization(20);
        }

        public Builder<T> allowParallelization(int maxThreads) {
            this.allowedThreads = maxThreads;
            return this;
        }

        public Builder<T> withLimitedScopeConfig(Config config) {
            this.limitedScopeConfig = config;
            return this;
        }

        public Builder<T> withPrioritizer(Comparator<T> prioritizer) {
            this.prioritizer = prioritizer;
            return this;
        }

        public Builder<T> storeRejectedRequests(String storeRejectedRequestsSetting) {
            this.storeRejectedRequestsSetting = storeRejectedRequestsSetting;
            return this;
        }

        public RequestAllocatorConfig<T> build() {
            if (this.limitedScopeConfig == null) {
                this.limitedScopeConfig = ConfigFactory.empty();
            }
            return new RequestAllocatorConfig<T>(this.prioritizer, this.resourceEstimator, this.allowedThreads, this.limitedScopeConfig, this.storeRejectedRequestsSetting);
        }
    }

    public static enum StoreRejectedRequestsConfig {
        ALL,
        MIN,
        NONE;

    }
}

