/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.request_allocation;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.gobblin.util.request_allocation.ResourceRequirement;
import org.apache.gobblin.util.request_allocation.VectorAlgebra;

public class ResourcePool {
    public static final double DEFAULT_DIMENSION_TOLERANCE = 1.2;
    private final ImmutableMap<String, Integer> dimensionIndex;
    private final double[] softBound;
    private final double[] hardBound;
    private final double[] defaultResourceUse;

    protected ResourcePool(Map<String, Double> maxResources, Map<String, Double> tolerances, Map<String, Double> defaultRequirements) {
        ImmutableMap.Builder indexBuilder = ImmutableMap.builder();
        this.softBound = new double[maxResources.size()];
        int currentIndex = 0;
        for (Map.Entry<String, Double> resource : maxResources.entrySet()) {
            indexBuilder.put((Object)resource.getKey(), (Object)currentIndex);
            this.softBound[currentIndex] = resource.getValue();
            ++currentIndex;
        }
        this.dimensionIndex = indexBuilder.build();
        this.hardBound = (double[])this.softBound.clone();
        int i = 0;
        while (i < this.hardBound.length) {
            int n = i++;
            this.hardBound[n] = this.hardBound[n] * 1.2;
        }
        this.defaultResourceUse = new double[this.softBound.length];
        for (Map.Entry idxEntry : this.dimensionIndex.entrySet()) {
            if (tolerances.containsKey(idxEntry.getKey())) {
                this.hardBound[((Integer)idxEntry.getValue()).intValue()] = this.softBound[(Integer)idxEntry.getValue()] * Math.max(1.0, tolerances.get(idxEntry.getKey()));
            }
            if (!defaultRequirements.containsKey(idxEntry.getKey())) continue;
            this.defaultResourceUse[((Integer)idxEntry.getValue()).intValue()] = defaultRequirements.get(idxEntry.getKey());
        }
    }

    private ResourcePool(double[] softBound, double[] hardBound, double[] defaultResourceUse, ImmutableMap<String, Integer> dimensionIndex) {
        this.softBound = softBound;
        this.hardBound = hardBound;
        this.defaultResourceUse = defaultResourceUse;
        this.dimensionIndex = dimensionIndex;
    }

    protected ResourcePool(ResourcePool other) {
        this.softBound = other.getSoftBound();
        this.hardBound = other.getHardBound();
        this.defaultResourceUse = other.getDefaultResourceUse();
        this.dimensionIndex = other.getDimensionIndex();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(ResourcePool.class.getSimpleName()).append(": {");
        builder.append("softBound").append(": ").append(this.vectorToString(this.softBound));
        builder.append(", ");
        builder.append("hardBound").append(": ").append(this.vectorToString(this.hardBound));
        builder.append("}");
        return builder.toString();
    }

    public String stringifyRequirement(ResourceRequirement requirement) {
        return this.vectorToString(requirement.getResourceVector());
    }

    private String vectorToString(double[] vector) {
        ArrayList tokens = Lists.newArrayListWithCapacity((int)this.dimensionIndex.size());
        for (Map.Entry dimension : this.dimensionIndex.entrySet()) {
            tokens.add((String)dimension.getKey() + ": " + vector[(Integer)dimension.getValue()]);
        }
        return Arrays.toString(tokens.toArray());
    }

    public boolean exceedsSoftBound(ResourceRequirement requirement, boolean orEqual) {
        return VectorAlgebra.exceedsVector(this.softBound, requirement.getResourceVector(), orEqual);
    }

    public boolean exceedsHardBound(ResourceRequirement requirement, boolean orEqual) {
        return VectorAlgebra.exceedsVector(this.hardBound, requirement.getResourceVector(), orEqual);
    }

    public ResourceRequirement.Builder getResourceRequirementBuilder() {
        return new ResourceRequirement.Builder(this);
    }

    protected ResourcePool contractPool(ResourceRequirement requirement) {
        return new ResourcePool(VectorAlgebra.addVector(this.softBound, requirement.getResourceVector(), -1.0, null), VectorAlgebra.addVector(this.hardBound, requirement.getResourceVector(), -1.0, null), this.defaultResourceUse, this.dimensionIndex);
    }

    int getNumDimensions() {
        return this.dimensionIndex.size();
    }

    double[] getDefaultResourceUse(double[] reuse) {
        if (reuse != null && this.defaultResourceUse.length == reuse.length) {
            System.arraycopy(this.defaultResourceUse, 0, reuse, 0, this.defaultResourceUse.length);
            return reuse;
        }
        return (double[])this.defaultResourceUse.clone();
    }

    public static ResourcePoolBuilder builder() {
        return new ResourcePoolBuilder();
    }

    protected ImmutableMap<String, Integer> getDimensionIndex() {
        return this.dimensionIndex;
    }

    protected double[] getSoftBound() {
        return this.softBound;
    }

    protected double[] getHardBound() {
        return this.hardBound;
    }

    protected double[] getDefaultResourceUse() {
        return this.defaultResourceUse;
    }

    public static class ResourcePoolBuilder {
        private ArrayList<String> maxResources$key;
        private ArrayList<Double> maxResources$value;
        private ArrayList<String> tolerances$key;
        private ArrayList<Double> tolerances$value;
        private ArrayList<String> defaultRequirements$key;
        private ArrayList<Double> defaultRequirements$value;

        ResourcePoolBuilder() {
        }

        public ResourcePoolBuilder maxResource(String maxResourceKey, Double maxResourceValue) {
            if (this.maxResources$key == null) {
                this.maxResources$key = new ArrayList();
                this.maxResources$value = new ArrayList();
            }
            this.maxResources$key.add(maxResourceKey);
            this.maxResources$value.add(maxResourceValue);
            return this;
        }

        public ResourcePoolBuilder maxResources(Map<? extends String, ? extends Double> maxResources) {
            if (maxResources == null) {
                throw new NullPointerException("maxResources cannot be null");
            }
            if (this.maxResources$key == null) {
                this.maxResources$key = new ArrayList();
                this.maxResources$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Double> $lombokEntry : maxResources.entrySet()) {
                this.maxResources$key.add($lombokEntry.getKey());
                this.maxResources$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public ResourcePoolBuilder clearMaxResources() {
            if (this.maxResources$key != null) {
                this.maxResources$key.clear();
                this.maxResources$value.clear();
            }
            return this;
        }

        public ResourcePoolBuilder tolerance(String toleranceKey, Double toleranceValue) {
            if (this.tolerances$key == null) {
                this.tolerances$key = new ArrayList();
                this.tolerances$value = new ArrayList();
            }
            this.tolerances$key.add(toleranceKey);
            this.tolerances$value.add(toleranceValue);
            return this;
        }

        public ResourcePoolBuilder tolerances(Map<? extends String, ? extends Double> tolerances) {
            if (tolerances == null) {
                throw new NullPointerException("tolerances cannot be null");
            }
            if (this.tolerances$key == null) {
                this.tolerances$key = new ArrayList();
                this.tolerances$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Double> $lombokEntry : tolerances.entrySet()) {
                this.tolerances$key.add($lombokEntry.getKey());
                this.tolerances$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public ResourcePoolBuilder clearTolerances() {
            if (this.tolerances$key != null) {
                this.tolerances$key.clear();
                this.tolerances$value.clear();
            }
            return this;
        }

        public ResourcePoolBuilder defaultRequirement(String defaultRequirementKey, Double defaultRequirementValue) {
            if (this.defaultRequirements$key == null) {
                this.defaultRequirements$key = new ArrayList();
                this.defaultRequirements$value = new ArrayList();
            }
            this.defaultRequirements$key.add(defaultRequirementKey);
            this.defaultRequirements$value.add(defaultRequirementValue);
            return this;
        }

        public ResourcePoolBuilder defaultRequirements(Map<? extends String, ? extends Double> defaultRequirements) {
            if (defaultRequirements == null) {
                throw new NullPointerException("defaultRequirements cannot be null");
            }
            if (this.defaultRequirements$key == null) {
                this.defaultRequirements$key = new ArrayList();
                this.defaultRequirements$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Double> $lombokEntry : defaultRequirements.entrySet()) {
                this.defaultRequirements$key.add($lombokEntry.getKey());
                this.defaultRequirements$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public ResourcePoolBuilder clearDefaultRequirements() {
            if (this.defaultRequirements$key != null) {
                this.defaultRequirements$key.clear();
                this.defaultRequirements$value.clear();
            }
            return this;
        }

        public ResourcePool build() {
            Map<String, Double> defaultRequirements;
            Map<String, Double> tolerances;
            Map<String, Double> maxResources;
            switch (this.maxResources$key == null ? 0 : this.maxResources$key.size()) {
                case 0: {
                    maxResources = Collections.emptyMap();
                    break;
                }
                case 1: {
                    maxResources = Collections.singletonMap(this.maxResources$key.get(0), this.maxResources$value.get(0));
                    break;
                }
                default: {
                    maxResources = new LinkedHashMap(this.maxResources$key.size() < 0x40000000 ? 1 + this.maxResources$key.size() + (this.maxResources$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.maxResources$key.size(); ++$i) {
                        maxResources.put(this.maxResources$key.get($i), this.maxResources$value.get($i));
                    }
                    maxResources = Collections.unmodifiableMap(maxResources);
                }
            }
            switch (this.tolerances$key == null ? 0 : this.tolerances$key.size()) {
                case 0: {
                    tolerances = Collections.emptyMap();
                    break;
                }
                case 1: {
                    tolerances = Collections.singletonMap(this.tolerances$key.get(0), this.tolerances$value.get(0));
                    break;
                }
                default: {
                    tolerances = new LinkedHashMap(this.tolerances$key.size() < 0x40000000 ? 1 + this.tolerances$key.size() + (this.tolerances$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.tolerances$key.size(); ++$i) {
                        tolerances.put(this.tolerances$key.get($i), this.tolerances$value.get($i));
                    }
                    tolerances = Collections.unmodifiableMap(tolerances);
                }
            }
            switch (this.defaultRequirements$key == null ? 0 : this.defaultRequirements$key.size()) {
                case 0: {
                    defaultRequirements = Collections.emptyMap();
                    break;
                }
                case 1: {
                    defaultRequirements = Collections.singletonMap(this.defaultRequirements$key.get(0), this.defaultRequirements$value.get(0));
                    break;
                }
                default: {
                    defaultRequirements = new LinkedHashMap<String, Double>(this.defaultRequirements$key.size() < 0x40000000 ? 1 + this.defaultRequirements$key.size() + (this.defaultRequirements$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.defaultRequirements$key.size(); ++$i) {
                        defaultRequirements.put(this.defaultRequirements$key.get($i), this.defaultRequirements$value.get($i));
                    }
                    defaultRequirements = Collections.unmodifiableMap(defaultRequirements);
                }
            }
            return new ResourcePool(maxResources, tolerances, defaultRequirements);
        }

        public String toString() {
            return "ResourcePool.ResourcePoolBuilder(maxResources$key=" + this.maxResources$key + ", maxResources$value=" + this.maxResources$value + ", tolerances$key=" + this.tolerances$key + ", tolerances$value=" + this.tolerances$value + ", defaultRequirements$key=" + this.defaultRequirements$key + ", defaultRequirements$value=" + this.defaultRequirements$value + ")";
        }
    }
}

