/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.request_allocation;

import org.apache.gobblin.util.request_allocation.ResourcePool;
import org.apache.gobblin.util.request_allocation.VectorAlgebra;

public class ResourceRequirement {
    private final double[] resourceVector;

    public ResourceRequirement(ResourceRequirement other) {
        this.resourceVector = (double[])other.resourceVector.clone();
    }

    public void add(ResourceRequirement other) {
        VectorAlgebra.addVector(this.resourceVector, other.resourceVector, 1.0, this.resourceVector);
    }

    public void subtract(ResourceRequirement other) {
        VectorAlgebra.addVector(this.resourceVector, other.resourceVector, -1.0, this.resourceVector);
    }

    void entryWiseMax(ResourceRequirement other) {
        for (int i = 0; i < this.resourceVector.length; ++i) {
            this.resourceVector[i] = Math.max(this.resourceVector[i], other.resourceVector[i]);
        }
    }

    ResourceRequirement copyInto(ResourceRequirement reuse) {
        if (reuse == null) {
            return new ResourceRequirement((double[])this.resourceVector.clone());
        }
        System.arraycopy(this.resourceVector, 0, reuse.getResourceVector(), 0, this.resourceVector.length);
        return reuse;
    }

    public static ResourceRequirement add(ResourceRequirement r1, ResourceRequirement r2, ResourceRequirement reuse) {
        if (reuse == null) {
            reuse = new ResourceRequirement((double[])r1.resourceVector.clone());
        }
        VectorAlgebra.addVector(r1.resourceVector, r2.resourceVector, 1.0, reuse.resourceVector);
        return reuse;
    }

    protected ResourceRequirement(double[] resourceVector) {
        this.resourceVector = resourceVector;
    }

    public double[] getResourceVector() {
        return this.resourceVector;
    }

    public static class Builder {
        private final double[] requirement;
        private final ResourcePool pool;

        public Builder(ResourcePool pool) {
            this.pool = pool;
            this.requirement = pool.getDefaultResourceUse(null);
        }

        public Builder zero() {
            for (int i = 0; i < this.requirement.length; ++i) {
                this.requirement[i] = 0.0;
            }
            return this;
        }

        public Builder setRequirement(String dimension, double value) {
            if (!this.pool.getDimensionIndex().containsKey((Object)dimension)) {
                throw new IllegalArgumentException(String.format("No dimension %s in this resource pool.", dimension));
            }
            int idx = (Integer)this.pool.getDimensionIndex().get((Object)dimension);
            this.requirement[idx] = value;
            return this;
        }

        public ResourceRequirement build() {
            return new ResourceRequirement(this.requirement);
        }
    }
}

