/*
 * Decompiled with CFR 0.152.
 */
package groovy.console.ui.text;

import groovy.lang.Tuple2;
import groovyjarjarantlr4.v4.runtime.ANTLRErrorListener;
import groovyjarjarantlr4.v4.runtime.CharStream;
import groovyjarjarantlr4.v4.runtime.CharStreams;
import groovyjarjarantlr4.v4.runtime.CodePointCharStream;
import groovyjarjarantlr4.v4.runtime.CommonTokenStream;
import groovyjarjarantlr4.v4.runtime.ConsoleErrorListener;
import groovyjarjarantlr4.v4.runtime.LexerNoViableAltException;
import groovyjarjarantlr4.v4.runtime.Token;
import groovyjarjarantlr4.v4.runtime.TokenSource;
import java.awt.Color;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import org.apache.groovy.parser.antlr4.GroovyLangLexer;
import org.apache.groovy.parser.antlr4.GroovySyntaxError;
import org.apache.groovy.parser.antlr4.util.PositionConfigureUtils;
import org.apache.groovy.parser.antlr4.util.StringUtils;
import org.apache.groovy.util.ReversedList;

public class SmartDocumentFilter
extends DocumentFilter {
    public static final List<Integer> HIGHLIGHTED_TOKEN_TYPE_LIST = Arrays.asList(7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 86, 85, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 17, 64, 63);
    private static final String MONOSPACED = "Monospaced";
    private final DefaultStyledDocument styledDocument;
    private final StyleContext styleContext;
    private final Style defaultStyle;
    private volatile boolean latest = false;
    private volatile List<Token> latestTokenList = Collections.emptyList();
    private volatile Tuple2<Integer, Integer> renderRange;

    public SmartDocumentFilter(DefaultStyledDocument styledDocument) {
        this.styledDocument = styledDocument;
        this.styleContext = StyleContext.getDefaultStyleContext();
        this.defaultStyle = this.styleContext.getStyle("default");
        StyleConstants.setFontFamily(this.defaultStyle, MONOSPACED);
        this.initStyles();
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attrs) throws BadLocationException {
        text = this.replaceMetaCharacters(text);
        fb.insertString(offset, text, attrs);
        this.parseDocument();
    }

    @Override
    public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
        fb.remove(offset, length);
        this.parseDocument();
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        if (text == null) {
            text = "";
        }
        text = this.replaceMetaCharacters(text);
        fb.replace(offset, length, text, attrs);
        this.parseDocument();
    }

    private String replaceMetaCharacters(String string) {
        string = string.replace("\r\n", "\n");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseDocument() throws BadLocationException {
        List<Token> tokenListToRender;
        GroovyLangLexer lexer;
        try {
            lexer = this.createLexer(this.styledDocument.getText(0, this.styledDocument.getLength()));
        }
        catch (IOException e) {
            e.printStackTrace();
            this.latest = false;
            return;
        }
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        try {
            tokenStream.fill();
        }
        catch (LexerNoViableAltException | GroovySyntaxError e) {
            this.latest = false;
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.latest = false;
            return;
        }
        List tokenList = tokenStream.getTokens();
        try {
            tokenListToRender = this.findTokensToRender(tokenList);
        }
        finally {
            this.setRenderRange(null);
        }
        for (Token token : tokenListToRender) {
            int tokenType = token.getType();
            if (-1 == tokenType) continue;
            int tokenStartIndex = token.getStartIndex();
            int tokenStopIndex = token.getStopIndex();
            int tokenLength = tokenStopIndex - tokenStartIndex + 1;
            this.styledDocument.setCharacterAttributes(tokenStartIndex, tokenLength, this.findStyleByTokenType(tokenType), true);
            if (2 != tokenType && 4 != tokenType) continue;
            this.styledDocument.setCharacterAttributes(tokenStartIndex + tokenLength - 1, 1, this.defaultStyle, true);
        }
        this.latestTokenList = tokenList;
        this.latest = true;
    }

    private List<Token> findTokensToRender(List<Token> tokenList) {
        Tuple2<Integer, Integer> renderRange = this.getRenderRange();
        if (null != renderRange) {
            long startLine = this.lineNumber((Integer)renderRange.getV1());
            long stopLine = this.lineNumber((Integer)renderRange.getV2());
            if (startLine < 0L || stopLine < 0L) {
                return tokenList;
            }
            return tokenList.stream().filter(e -> (long)e.getLine() >= startLine && (long)((Integer)PositionConfigureUtils.endPosition((Token)e).getV1()).intValue() <= stopLine).collect(Collectors.toList());
        }
        List<Token> tmpLatestTokenList = this.filterNewlines(this.latestTokenList);
        int latestTokenListSize = tmpLatestTokenList.size();
        if (0 == latestTokenListSize) {
            return tokenList;
        }
        List<Token> tmpTokenList = this.filterNewlines(tokenList);
        int tmpTokenListSize = tmpTokenList.size();
        if (0 == tmpTokenListSize) {
            return tokenList;
        }
        int startTokenIndex = 0;
        int minSize = Math.min(tmpTokenListSize, latestTokenListSize);
        for (int i = 0; i < minSize; ++i) {
            Token token = tmpTokenList.get(i);
            Token latestToken = tmpLatestTokenList.get(i);
            if (token.getType() == latestToken.getType() && token.getStartIndex() == latestToken.getStartIndex() && token.getStopIndex() == latestToken.getStopIndex()) continue;
            startTokenIndex = i;
            break;
        }
        ReversedList newTokenList = new ReversedList(tmpTokenList);
        ReversedList newLatestTokenList = new ReversedList(tmpLatestTokenList);
        int stopTokenIndex = tmpTokenListSize;
        Token lastToken = (Token)newTokenList.get(0);
        Token lastLatestToken = (Token)newLatestTokenList.get(0);
        for (int i = 0; i < minSize; ++i) {
            Token token = (Token)newTokenList.get(i);
            Token latestToken = (Token)newLatestTokenList.get(i);
            if (token.getType() == latestToken.getType() && token.getStartIndex() - lastToken.getStartIndex() == latestToken.getStartIndex() - lastLatestToken.getStartIndex() && token.getStopIndex() - lastToken.getStopIndex() == latestToken.getStopIndex() - lastLatestToken.getStopIndex()) continue;
            stopTokenIndex = tmpTokenListSize - i;
            break;
        }
        if (startTokenIndex == stopTokenIndex) {
            return tmpTokenListSize != latestTokenListSize ? tokenList : Collections.emptyList();
        }
        if (startTokenIndex < stopTokenIndex) {
            return tmpTokenList.subList(startTokenIndex, stopTokenIndex);
        }
        return tokenList;
    }

    private long lineNumber(int position) {
        long result = -1L;
        if (position < 0) {
            return result;
        }
        try {
            String text = this.styledDocument.getText(0, position + 1);
            result = StringUtils.countChar((String)text, (char)'\n') + 1L;
        }
        catch (BadLocationException e) {
            e.printStackTrace(System.err);
        }
        return result;
    }

    private List<Token> filterNewlines(List<Token> tokenList) {
        return tokenList.stream().filter(e -> 136 != e.getType() || !e.getText().trim().isEmpty()).collect(Collectors.toList());
    }

    private Style findStyleByTokenType(int tokenType) {
        Style style = this.styleContext.getStyle(String.valueOf(tokenType));
        return null == style ? this.defaultStyle : style;
    }

    private Style createDefaultStyleByTokenType(int tokenType) {
        return this.styleContext.addStyle(String.valueOf(tokenType), this.defaultStyle);
    }

    private GroovyLangLexer createLexer(String text) throws IOException {
        CodePointCharStream charStream = CharStreams.fromReader((Reader)new StringReader(text));
        GroovyLangLexer lexer = new GroovyLangLexer((CharStream)charStream);
        lexer.setErrorIgnored(true);
        lexer.removeErrorListener((ANTLRErrorListener)ConsoleErrorListener.INSTANCE);
        return lexer;
    }

    private void initStyles() {
        Style style;
        Style comment = this.createDefaultStyleByTokenType(136);
        StyleConstants.setForeground(comment, Color.LIGHT_GRAY.darker().darker());
        StyleConstants.setItalic(comment, true);
        for (int t : Arrays.asList(2, 4, 3)) {
            Style style2 = this.createDefaultStyleByTokenType(t);
            StyleConstants.setForeground(style2, Color.MAGENTA.darker().darker());
        }
        Style stringLiteral = this.createDefaultStyleByTokenType(1);
        StyleConstants.setForeground(stringLiteral, Color.GREEN.darker().darker());
        for (int t : Arrays.asList(61, 62)) {
            style = this.createDefaultStyleByTokenType(t);
            StyleConstants.setForeground(style, Color.RED.darker());
        }
        for (int t : HIGHLIGHTED_TOKEN_TYPE_LIST) {
            style = this.createDefaultStyleByTokenType(t);
            StyleConstants.setBold(style, true);
            StyleConstants.setForeground(style, Color.BLUE.darker().darker());
        }
        for (int t : Arrays.asList(94, 93)) {
            style = this.createDefaultStyleByTokenType(t);
            StyleConstants.setForeground(style, Color.BLUE.darker());
        }
        Style unexpectedChar = this.createDefaultStyleByTokenType(138);
        StyleConstants.setForeground(unexpectedChar, Color.CYAN.darker());
    }

    public boolean isLatest() {
        return this.latest;
    }

    public List<Token> getLatestTokenList() {
        return this.latestTokenList;
    }

    public void setRenderRange(Tuple2<Integer, Integer> renderRange) {
        this.renderRange = renderRange;
    }

    public Tuple2<Integer, Integer> getRenderRange() {
        return this.renderRange;
    }
}

