/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.protocol;

import java.util.List;
import org.apache.guacamole.GuacamoleConnectionClosedException;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.io.GuacamoleReader;
import org.apache.guacamole.io.GuacamoleWriter;
import org.apache.guacamole.net.DelegatingGuacamoleSocket;
import org.apache.guacamole.net.GuacamoleSocket;
import org.apache.guacamole.protocol.GuacamoleClientInformation;
import org.apache.guacamole.protocol.GuacamoleConfiguration;
import org.apache.guacamole.protocol.GuacamoleInstruction;
import org.apache.guacamole.protocol.GuacamoleProtocolCapability;
import org.apache.guacamole.protocol.GuacamoleProtocolVersion;
import org.apache.guacamole.protocol.GuacamoleStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfiguredGuacamoleSocket
extends DelegatingGuacamoleSocket {
    private static final Logger logger = LoggerFactory.getLogger(ConfiguredGuacamoleSocket.class);
    private GuacamoleConfiguration config;
    private String id;
    private GuacamoleProtocolVersion protocolVersion = GuacamoleProtocolVersion.VERSION_1_0_0;

    private static void handleReceivedError(GuacamoleInstruction instruction) throws GuacamoleException {
        GuacamoleStatus status;
        String message;
        block7: {
            message = "Internal error within guacd / protocol handling.";
            status = GuacamoleStatus.SERVER_ERROR;
            List<String> args = instruction.getArgs();
            if (args.size() >= 1) {
                message = args.get(0);
            } else {
                logger.debug("Received \"error\" instruction with no corresponding message.");
            }
            if (args.size() >= 2) {
                try {
                    int statusCode = Integer.parseInt(args.get(1));
                    GuacamoleStatus parsedStatus = GuacamoleStatus.fromGuacamoleStatusCode(statusCode);
                    if (parsedStatus != null) {
                        status = parsedStatus;
                        break block7;
                    }
                    logger.debug("Received \"error\" instruction with unknown/invalid status code: {}", (Object)statusCode);
                }
                catch (NumberFormatException e) {
                    logger.debug("Received \"error\" instruction with non-numeric status code.", (Throwable)e);
                }
            } else {
                logger.debug("Received \"error\" instruction without status code.");
            }
        }
        throw status.toException(message);
    }

    private GuacamoleInstruction expect(GuacamoleReader reader, String opcode) throws GuacamoleException {
        GuacamoleInstruction instruction = reader.readInstruction();
        if (instruction == null) {
            throw new GuacamoleServerException("End of stream while waiting for \"" + opcode + "\".");
        }
        if ("disconnect".equals(instruction.getOpcode())) {
            throw new GuacamoleConnectionClosedException("Server disconnected while waiting for \"" + opcode + "\".");
        }
        if ("error".equals(instruction.getOpcode())) {
            ConfiguredGuacamoleSocket.handleReceivedError(instruction);
        }
        if (!instruction.getOpcode().equals(opcode)) {
            throw new GuacamoleServerException("Expected \"" + opcode + "\" instruction but instead received \"" + instruction.getOpcode() + "\".");
        }
        return instruction;
    }

    public ConfiguredGuacamoleSocket(GuacamoleSocket socket, GuacamoleConfiguration config) throws GuacamoleException {
        this(socket, config, new GuacamoleClientInformation());
    }

    public ConfiguredGuacamoleSocket(GuacamoleSocket socket, GuacamoleConfiguration config, GuacamoleClientInformation info) throws GuacamoleException {
        super(socket);
        String name;
        String timezone;
        this.config = config;
        GuacamoleReader reader = socket.getReader();
        GuacamoleWriter writer = socket.getWriter();
        String select_arg = config.getConnectionID();
        if (select_arg == null) {
            select_arg = config.getProtocol();
        }
        writer.writeInstruction(new GuacamoleInstruction("select", select_arg));
        GuacamoleInstruction args = this.expect(reader, "args");
        List<String> arg_names = args.getArgs();
        String[] arg_values = new String[arg_names.size()];
        for (int i = 0; i < arg_names.size(); ++i) {
            GuacamoleProtocolVersion version;
            String arg_name = arg_names.get(i);
            if (i == 0 && (version = GuacamoleProtocolVersion.parseVersion(arg_name)) != null) {
                if (version.atLeast(GuacamoleProtocolVersion.LATEST)) {
                    version = GuacamoleProtocolVersion.LATEST;
                }
                arg_values[i] = version.toString();
                this.protocolVersion = version;
                continue;
            }
            String value = config.getParameter(arg_name);
            arg_values[i] = value != null ? value : "";
        }
        writer.writeInstruction(new GuacamoleInstruction("size", Integer.toString(info.getOptimalScreenWidth()), Integer.toString(info.getOptimalScreenHeight()), Integer.toString(info.getOptimalResolution())));
        writer.writeInstruction(new GuacamoleInstruction("audio", info.getAudioMimetypes().toArray(new String[0])));
        writer.writeInstruction(new GuacamoleInstruction("video", info.getVideoMimetypes().toArray(new String[0])));
        writer.writeInstruction(new GuacamoleInstruction("image", info.getImageMimetypes().toArray(new String[0])));
        if (GuacamoleProtocolCapability.TIMEZONE_HANDSHAKE.isSupported(this.protocolVersion) && (timezone = info.getTimezone()) != null) {
            writer.writeInstruction(new GuacamoleInstruction("timezone", timezone));
        }
        if (GuacamoleProtocolCapability.NAME_HANDSHAKE.isSupported(this.protocolVersion) && (name = info.getName()) != null) {
            writer.writeInstruction(new GuacamoleInstruction("name", name));
        }
        writer.writeInstruction(new GuacamoleInstruction("connect", arg_values));
        GuacamoleInstruction ready = this.expect(reader, "ready");
        List<String> ready_args = ready.getArgs();
        if (ready_args.isEmpty()) {
            throw new GuacamoleServerException("No connection ID received");
        }
        this.id = ready.getArgs().get(0);
    }

    public GuacamoleConfiguration getConfiguration() {
        return this.config;
    }

    public String getConnectionID() {
        return this.id;
    }

    public GuacamoleProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public String getProtocol() {
        return this.getConfiguration().getProtocol();
    }
}

