/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.net.auth.simple;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.environment.LocalEnvironment;
import org.apache.guacamole.net.GuacamoleSocket;
import org.apache.guacamole.net.GuacamoleTunnel;
import org.apache.guacamole.net.InetGuacamoleSocket;
import org.apache.guacamole.net.SSLGuacamoleSocket;
import org.apache.guacamole.net.SimpleGuacamoleTunnel;
import org.apache.guacamole.net.auth.AbstractConnection;
import org.apache.guacamole.net.auth.ConnectionRecord;
import org.apache.guacamole.net.auth.GuacamoleProxyConfiguration;
import org.apache.guacamole.protocol.ConfiguredGuacamoleSocket;
import org.apache.guacamole.protocol.GuacamoleClientInformation;
import org.apache.guacamole.protocol.GuacamoleConfiguration;

public class SimpleConnection
extends AbstractConnection {
    private GuacamoleConfiguration config;

    public SimpleConnection() {
    }

    public SimpleConnection(String name, String identifier, GuacamoleConfiguration config) {
        this.setName(name);
        this.setIdentifier(identifier);
        this.setConfiguration(config);
        this.config = config;
    }

    @Override
    public int getActiveConnections() {
        return 0;
    }

    @Override
    public Map<String, String> getAttributes() {
        return Collections.emptyMap();
    }

    @Override
    public void setAttributes(Map<String, String> attributes) {
    }

    @Override
    public GuacamoleTunnel connect(GuacamoleClientInformation info) throws GuacamoleException {
        ConfiguredGuacamoleSocket socket;
        LocalEnvironment environment = new LocalEnvironment();
        GuacamoleProxyConfiguration proxyConfig = environment.getDefaultGuacamoleProxyConfiguration();
        String hostname = proxyConfig.getHostname();
        int port = proxyConfig.getPort();
        switch (proxyConfig.getEncryptionMethod()) {
            case SSL: {
                socket = new ConfiguredGuacamoleSocket((GuacamoleSocket)new SSLGuacamoleSocket(hostname, port), this.config, info);
                break;
            }
            case NONE: {
                socket = new ConfiguredGuacamoleSocket((GuacamoleSocket)new InetGuacamoleSocket(hostname, port), this.config, info);
                break;
            }
            default: {
                throw new GuacamoleServerException("Unimplemented encryption method.");
            }
        }
        return new SimpleGuacamoleTunnel((GuacamoleSocket)socket);
    }

    @Override
    public Date getLastActive() {
        return null;
    }

    public List<ConnectionRecord> getHistory() throws GuacamoleException {
        return Collections.emptyList();
    }
}

