/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.net.auth.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleSecurityException;
import org.apache.guacamole.net.auth.Directory;
import org.apache.guacamole.net.auth.Identifiable;

public class SimpleDirectory<ObjectType extends Identifiable>
implements Directory<ObjectType> {
    private Map<String, ObjectType> objects = Collections.emptyMap();

    public SimpleDirectory() {
    }

    public SimpleDirectory(Map<String, ObjectType> objects) {
        this.objects = objects;
    }

    protected void setObjects(Map<String, ObjectType> objects) {
        this.objects = objects;
    }

    protected Map<String, ObjectType> getObjects() {
        return this.objects;
    }

    @Override
    public ObjectType get(String identifier) throws GuacamoleException {
        return (ObjectType)((Identifiable)this.objects.get(identifier));
    }

    @Override
    public Collection<ObjectType> getAll(Collection<String> identifiers) throws GuacamoleException {
        ArrayList<Identifiable> foundObjects = new ArrayList<Identifiable>(identifiers.size());
        for (String identifier : identifiers) {
            Identifiable object = (Identifiable)this.objects.get(identifier);
            if (object == null) continue;
            foundObjects.add(object);
        }
        return foundObjects;
    }

    @Override
    public Set<String> getIdentifiers() throws GuacamoleException {
        return this.objects.keySet();
    }

    @Override
    public void add(ObjectType connection) throws GuacamoleException {
        throw new GuacamoleSecurityException("Permission denied.");
    }

    @Override
    public void update(ObjectType connection) throws GuacamoleException {
        throw new GuacamoleSecurityException("Permission denied.");
    }

    @Override
    public void remove(String identifier) throws GuacamoleException {
        throw new GuacamoleSecurityException("Permission denied.");
    }
}

