/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.net.auth.simple;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.net.auth.AbstractUser;
import org.apache.guacamole.net.auth.ActivityRecord;
import org.apache.guacamole.net.auth.permission.ObjectPermission;
import org.apache.guacamole.net.auth.permission.ObjectPermissionSet;
import org.apache.guacamole.net.auth.permission.SystemPermissionSet;
import org.apache.guacamole.net.auth.simple.SimpleObjectPermissionSet;
import org.apache.guacamole.net.auth.simple.SimpleSystemPermissionSet;

public class SimpleUser
extends AbstractUser {
    private final Set<ObjectPermission> userPermissions = new HashSet<ObjectPermission>();
    private final Set<ObjectPermission> connectionPermissions = new HashSet<ObjectPermission>();
    private final Set<ObjectPermission> connectionGroupPermissions = new HashSet<ObjectPermission>();

    public SimpleUser() {
    }

    public SimpleUser(String username) {
        this.setIdentifier(username);
    }

    private void addReadPermissions(Set<ObjectPermission> permissions, Collection<String> identifiers) {
        for (String identifier : identifiers) {
            permissions.add(new ObjectPermission(ObjectPermission.Type.READ, identifier));
        }
    }

    public SimpleUser(String username, Collection<String> connectionIdentifiers, Collection<String> connectionGroupIdentifiers) {
        this(username);
        this.addReadPermissions(this.connectionPermissions, connectionIdentifiers);
        this.addReadPermissions(this.connectionGroupPermissions, connectionGroupIdentifiers);
    }

    public SimpleUser(String username, Collection<String> userIdentifiers, Collection<String> connectionIdentifiers, Collection<String> connectionGroupIdentifiers) {
        this(username);
        this.addReadPermissions(this.userPermissions, userIdentifiers);
        this.addReadPermissions(this.connectionPermissions, connectionIdentifiers);
        this.addReadPermissions(this.connectionGroupPermissions, connectionGroupIdentifiers);
    }

    @Override
    public Map<String, String> getAttributes() {
        return Collections.emptyMap();
    }

    @Override
    public void setAttributes(Map<String, String> attributes) {
    }

    @Override
    public Date getLastActive() {
        return null;
    }

    public List<ActivityRecord> getHistory() throws GuacamoleException {
        return Collections.emptyList();
    }

    @Override
    public SystemPermissionSet getSystemPermissions() throws GuacamoleException {
        return new SimpleSystemPermissionSet();
    }

    @Override
    public ObjectPermissionSet getConnectionPermissions() throws GuacamoleException {
        return new SimpleObjectPermissionSet(this.connectionPermissions);
    }

    @Override
    public ObjectPermissionSet getConnectionGroupPermissions() throws GuacamoleException {
        return new SimpleObjectPermissionSet(this.connectionGroupPermissions);
    }

    @Override
    public ObjectPermissionSet getUserPermissions() throws GuacamoleException {
        return new SimpleObjectPermissionSet(this.userPermissions);
    }

    @Override
    public ObjectPermissionSet getActiveConnectionPermissions() throws GuacamoleException {
        return new SimpleObjectPermissionSet();
    }

    @Override
    public ObjectPermissionSet getSharingProfilePermissions() {
        return new SimpleObjectPermissionSet();
    }
}

