/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.token;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.guacamole.net.auth.AuthenticatedUser;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.token.TokenFilter;

public class StandardTokens {
    public static final String USERNAME_TOKEN = "GUAC_USERNAME";
    public static final String PASSWORD_TOKEN = "GUAC_PASSWORD";
    public static final String CLIENT_HOSTNAME_TOKEN = "GUAC_CLIENT_HOSTNAME";
    public static final String CLIENT_ADDRESS_TOKEN = "GUAC_CLIENT_ADDRESS";
    public static final String DATE_TOKEN = "GUAC_DATE";
    public static final String TIME_TOKEN = "GUAC_TIME";
    private static final String DATE_FORMAT = "yyyyMMdd";
    private static final String TIME_FORMAT = "HHmmss";

    private StandardTokens() {
    }

    public static void addStandardTokens(TokenFilter filter) {
        Date currentTime = new Date();
        filter.setToken(DATE_TOKEN, new SimpleDateFormat(DATE_FORMAT).format(currentTime));
        filter.setToken(TIME_TOKEN, new SimpleDateFormat(TIME_FORMAT).format(currentTime));
    }

    public static void addStandardTokens(TokenFilter filter, Credentials credentials) {
        String address;
        String hostname;
        String password;
        String username = credentials.getUsername();
        if (username != null) {
            filter.setToken(USERNAME_TOKEN, username);
        }
        if ((password = credentials.getPassword()) != null) {
            filter.setToken(PASSWORD_TOKEN, password);
        }
        if ((hostname = credentials.getRemoteHostname()) != null) {
            filter.setToken(CLIENT_HOSTNAME_TOKEN, hostname);
        }
        if ((address = credentials.getRemoteAddress()) != null) {
            filter.setToken(CLIENT_ADDRESS_TOKEN, address);
        }
        StandardTokens.addStandardTokens(filter);
    }

    public static void addStandardTokens(TokenFilter filter, AuthenticatedUser user) {
        filter.setToken(USERNAME_TOKEN, user.getIdentifier());
        StandardTokens.addStandardTokens(filter, user.getCredentials());
    }
}

