/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.net.auth;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.net.GuacamoleTunnel;
import org.apache.guacamole.net.auth.ActivityRecordSet;
import org.apache.guacamole.net.auth.Connection;
import org.apache.guacamole.net.auth.ConnectionRecord;
import org.apache.guacamole.protocol.GuacamoleClientInformation;
import org.apache.guacamole.protocol.GuacamoleConfiguration;

public class DelegatingConnection
implements Connection {
    private final Connection connection;
    private final ThreadLocal<Map<String, String>> currentTokens = new ThreadLocal<Map<String, String>>(){

        @Override
        protected Map<String, String> initialValue() {
            return Collections.emptyMap();
        }
    };

    public DelegatingConnection(Connection connection) {
        this.connection = connection;
    }

    protected Connection getDelegateConnection() {
        return this.connection;
    }

    @Override
    public String getIdentifier() {
        return this.connection.getIdentifier();
    }

    @Override
    public void setIdentifier(String identifier) {
        this.connection.setIdentifier(identifier);
    }

    @Override
    public String getName() {
        return this.connection.getName();
    }

    @Override
    public void setName(String name) {
        this.connection.setName(name);
    }

    @Override
    public String getParentIdentifier() {
        return this.connection.getParentIdentifier();
    }

    @Override
    public void setParentIdentifier(String parentIdentifier) {
        this.connection.setParentIdentifier(parentIdentifier);
    }

    @Override
    public GuacamoleConfiguration getConfiguration() {
        return this.connection.getConfiguration();
    }

    @Override
    public void setConfiguration(GuacamoleConfiguration config) {
        this.connection.setConfiguration(config);
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.connection.getAttributes();
    }

    @Override
    public void setAttributes(Map<String, String> attributes) {
        this.connection.setAttributes(attributes);
    }

    @Override
    public Date getLastActive() {
        return this.connection.getLastActive();
    }

    @Override
    @Deprecated
    public List<? extends ConnectionRecord> getHistory() throws GuacamoleException {
        return this.connection.getHistory();
    }

    @Override
    public ActivityRecordSet<ConnectionRecord> getConnectionHistory() throws GuacamoleException {
        return this.connection.getConnectionHistory();
    }

    @Override
    public Set<String> getSharingProfileIdentifiers() throws GuacamoleException {
        return this.connection.getSharingProfileIdentifiers();
    }

    @Override
    @Deprecated
    public GuacamoleTunnel connect(GuacamoleClientInformation info) throws GuacamoleException {
        return this.connection.connect(info, this.currentTokens.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GuacamoleTunnel connect(GuacamoleClientInformation info, Map<String, String> tokens) throws GuacamoleException {
        try {
            this.currentTokens.set(tokens);
            GuacamoleTunnel guacamoleTunnel = this.connect(info);
            return guacamoleTunnel;
        }
        finally {
            this.currentTokens.remove();
        }
    }

    @Override
    public int getActiveConnections() {
        return this.connection.getActiveConnections();
    }
}

