/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.net.auth.simple;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.net.auth.AbstractUser;
import org.apache.guacamole.net.auth.permission.ObjectPermission;
import org.apache.guacamole.net.auth.permission.ObjectPermissionSet;
import org.apache.guacamole.net.auth.simple.SimpleObjectPermissionSet;

public class SimpleUser
extends AbstractUser {
    private final Set<ObjectPermission> userPermissions = new HashSet<ObjectPermission>();
    private final Set<ObjectPermission> connectionPermissions = new HashSet<ObjectPermission>();
    private final Set<ObjectPermission> connectionGroupPermissions = new HashSet<ObjectPermission>();

    public SimpleUser() {
    }

    public SimpleUser(String username) {
        super.setIdentifier(username);
    }

    private void addReadPermissions(Set<ObjectPermission> permissions, Collection<String> identifiers) {
        identifiers.forEach(identifier -> permissions.add(new ObjectPermission(ObjectPermission.Type.READ, (String)identifier)));
    }

    @Deprecated
    public SimpleUser(String username, Collection<String> connectionIdentifiers, Collection<String> connectionGroupIdentifiers) {
        this(username);
        this.addReadPermissions(this.connectionPermissions, connectionIdentifiers);
        this.addReadPermissions(this.connectionGroupPermissions, connectionGroupIdentifiers);
    }

    @Deprecated
    public SimpleUser(String username, Collection<String> userIdentifiers, Collection<String> connectionIdentifiers, Collection<String> connectionGroupIdentifiers) {
        this(username);
        this.addReadPermissions(this.userPermissions, userIdentifiers);
        this.addReadPermissions(this.connectionPermissions, connectionIdentifiers);
        this.addReadPermissions(this.connectionGroupPermissions, connectionGroupIdentifiers);
    }

    @Override
    public ObjectPermissionSet getConnectionPermissions() throws GuacamoleException {
        return new SimpleObjectPermissionSet(this.connectionPermissions);
    }

    @Override
    public ObjectPermissionSet getConnectionGroupPermissions() throws GuacamoleException {
        return new SimpleObjectPermissionSet(this.connectionGroupPermissions);
    }

    @Override
    public ObjectPermissionSet getUserPermissions() throws GuacamoleException {
        return new SimpleObjectPermissionSet(this.userPermissions);
    }
}

