/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.properties;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.properties.GuacamoleProperty;

public abstract class EnumGuacamoleProperty<T extends Enum<T>>
implements GuacamoleProperty<T> {
    private final Map<String, T> valueMapping;

    private static <T extends Enum<T>> Map<String, T> getValueMapping(Class<T> enumClass) {
        Enum[] values = (Enum[])enumClass.getEnumConstants();
        HashMap<String, Enum> valueMapping = new HashMap<String, Enum>(values.length);
        for (Enum value : values) {
            Field field;
            try {
                field = enumClass.getDeclaredField(value.name());
            }
            catch (NoSuchFieldException e) {
                throw new IllegalStateException("Fields of enum do not match declared values.", e);
            }
            PropertyValue valueAnnotation = field.getAnnotation(PropertyValue.class);
            if (valueAnnotation == null) continue;
            valueMapping.put(valueAnnotation.value(), value);
        }
        return valueMapping;
    }

    private static <T extends Enum<T>> Map<String, T> mapOf(String key, T value, Object ... additional) throws IllegalArgumentException {
        if (additional.length % 2 != 0) {
            throw new IllegalArgumentException("Array of additional key/value pairs must be even in length.");
        }
        HashMap<String, Enum> valueMapping = new HashMap<String, Enum>(1 + additional.length);
        valueMapping.put(key, value);
        Class<T> enumClass = value.getDeclaringClass();
        for (int i = 0; i < additional.length; i += 2) {
            Object additionalKey = additional[i];
            if (!(additionalKey instanceof String)) {
                throw new IllegalArgumentException("Keys of additional key/value pairs must be strings.");
            }
            Object additionalValue = additional[i + 1];
            if (!(additionalValue instanceof Enum) || enumClass != ((Enum)additionalValue).getDeclaringClass()) {
                throw new IllegalArgumentException("Values of additional key/value pairs must be enum constants of the correct type.");
            }
            valueMapping.put((String)additionalKey, (Enum)additionalValue);
        }
        return valueMapping;
    }

    public EnumGuacamoleProperty(Map<String, T> valueMapping) {
        this.valueMapping = valueMapping;
    }

    public EnumGuacamoleProperty(Class<T> enumClass) {
        this(EnumGuacamoleProperty.getValueMapping(enumClass));
    }

    public EnumGuacamoleProperty(String key, T value, Object ... additional) throws IllegalArgumentException {
        this(EnumGuacamoleProperty.mapOf(key, value, additional));
    }

    @Override
    public T parseValue(String value) throws GuacamoleException {
        if (value == null) {
            return null;
        }
        Enum parsedValue = (Enum)this.valueMapping.get(value);
        if (parsedValue != null) {
            return (T)parsedValue;
        }
        ArrayList<String> legalValues = new ArrayList<String>(this.valueMapping.keySet());
        Collections.sort(legalValues);
        throw new GuacamoleServerException(String.format("\"%s\" is not a valid value for property \"%s\". Valid values are: \"%s\"", value, this.getName(), String.join((CharSequence)"\", \"", legalValues)));
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface PropertyValue {
        public String value();
    }
}

