/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.properties;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.properties.PropertiesGuacamoleProperties;

public class FileGuacamoleProperties
extends PropertiesGuacamoleProperties {
    private static Properties read(File propertiesFile) throws GuacamoleException {
        if (!propertiesFile.exists()) {
            throw new GuacamoleServerException(String.format("\"%s\" does not exist.", propertiesFile));
        }
        Properties properties = new Properties();
        try (FileInputStream stream = new FileInputStream(propertiesFile);){
            properties.load(stream);
        }
        catch (IOException e) {
            throw new GuacamoleServerException(String.format("\"%s\" cannot be read: %s", propertiesFile, e.getMessage()), (Throwable)e);
        }
        return properties;
    }

    public FileGuacamoleProperties(File propertiesFile) throws GuacamoleException {
        super(FileGuacamoleProperties.read(propertiesFile));
    }
}

