/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.net.auth.simple;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.net.auth.AbstractAuthenticatedUser;
import org.apache.guacamole.net.auth.AbstractAuthenticationProvider;
import org.apache.guacamole.net.auth.AuthenticatedUser;
import org.apache.guacamole.net.auth.AuthenticationProvider;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.net.auth.UserContext;
import org.apache.guacamole.net.auth.simple.SimpleUserContext;
import org.apache.guacamole.protocol.GuacamoleConfiguration;

public abstract class SimpleAuthenticationProvider
extends AbstractAuthenticationProvider {
    public abstract Map<String, GuacamoleConfiguration> getAuthorizedConfigurations(Credentials var1) throws GuacamoleException;

    @Override
    public AuthenticatedUser authenticateUser(Credentials credentials) throws GuacamoleException {
        Map<String, GuacamoleConfiguration> configs = this.getAuthorizedConfigurations(credentials);
        if (configs == null) {
            return null;
        }
        return new SimpleAuthenticatedUser(credentials, configs);
    }

    @Override
    public UserContext getUserContext(AuthenticatedUser authenticatedUser) throws GuacamoleException {
        Map<String, GuacamoleConfiguration> configs = this.getAuthorizedConfigurations(authenticatedUser.getCredentials());
        if (configs == null) {
            return null;
        }
        return new SimpleUserContext(this, authenticatedUser.getIdentifier(), configs, true);
    }

    private class SimpleAuthenticatedUser
    extends AbstractAuthenticatedUser {
        private final Credentials credentials;
        private final Map<String, GuacamoleConfiguration> configs;

        public SimpleAuthenticatedUser(Credentials credentials, Map<String, GuacamoleConfiguration> configs) {
            this.credentials = credentials;
            this.configs = configs;
            String username = credentials.getUsername();
            if (username != null && !username.isEmpty()) {
                this.setIdentifier(username);
            } else {
                this.setIdentifier(UUID.randomUUID().toString());
            }
        }

        public Map<String, GuacamoleConfiguration> getAuthorizedConfigurations() {
            return this.configs;
        }

        @Override
        public AuthenticationProvider getAuthenticationProvider() {
            return SimpleAuthenticationProvider.this;
        }

        @Override
        public Credentials getCredentials() {
            return this.credentials;
        }

        @Override
        public Set<String> getEffectiveUserGroups() {
            return Collections.emptySet();
        }
    }
}

