/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.token;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TokenName {
    private static final Pattern STRING_NAME_GROUPING = Pattern.compile("\\p{javaUpperCase}\\p{javaLowerCase}+|[0-9]+|\\p{javaUpperCase}+(?!\\p{javaLowerCase})|\\p{javaLowerCase}+|\\b\\w+\\b");

    private TokenName() {
    }

    public static String canonicalize(String name, String prefix) {
        Matcher groupMatcher = STRING_NAME_GROUPING.matcher(name);
        if (!groupMatcher.find()) {
            return prefix + name.toUpperCase();
        }
        StringBuilder builder = new StringBuilder(prefix);
        builder.append(groupMatcher.group(0).toUpperCase());
        while (groupMatcher.find()) {
            builder.append("_");
            builder.append(groupMatcher.group(0).toUpperCase());
        }
        return builder.toString();
    }

    public static String canonicalize(String name) {
        return TokenName.canonicalize(name, "");
    }
}

