/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.environment;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.environment.Environment;
import org.apache.guacamole.net.auth.GuacamoleProxyConfiguration;
import org.apache.guacamole.properties.GuacamoleProperties;
import org.apache.guacamole.properties.GuacamoleProperty;
import org.apache.guacamole.protocols.ProtocolInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalEnvironment
implements Environment {
    private static final Logger logger = LoggerFactory.getLogger(LocalEnvironment.class);
    private static final String[] KNOWN_PROTOCOLS = new String[]{"kubernetes", "rdp", "ssh", "telnet", "vnc"};
    private static final String DEFAULT_GUACD_HOSTNAME = "localhost";
    private static final int DEFAULT_GUACD_PORT = 4822;
    private static final boolean DEFAULT_GUACD_SSL = false;
    private final File guacHome = LocalEnvironment.findGuacamoleHome();
    private final Map<String, ProtocolInfo> availableProtocols;
    private static final List<GuacamoleProperties> availableProperties = new CopyOnWriteArrayList<GuacamoleProperties>();
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final LocalEnvironment instance = new LocalEnvironment();

    public static LocalEnvironment getInstance() {
        return instance;
    }

    @Deprecated
    public LocalEnvironment() {
        logger.info("GUACAMOLE_HOME is \"{}\".", (Object)this.guacHome.getAbsolutePath());
        this.availableProtocols = this.readProtocols();
    }

    private static File findGuacamoleHome() {
        File guacHome;
        String desiredDir = System.getProperty("guacamole.home");
        if (desiredDir == null) {
            desiredDir = System.getenv("GUACAMOLE_HOME");
        }
        if (desiredDir != null) {
            guacHome = new File(desiredDir);
        } else {
            guacHome = new File(System.getProperty("user.home"), ".guacamole");
            if (!guacHome.exists() && new File("/etc").exists()) {
                guacHome = new File("/etc/guacamole");
            }
        }
        return guacHome;
    }

    private ProtocolInfo readProtocol(InputStream input) throws IOException {
        return (ProtocolInfo)mapper.readValue(input, ProtocolInfo.class);
    }

    private Map<String, ProtocolInfo> readProtocols() {
        HashMap<String, ProtocolInfo> protocols = new HashMap<String, ProtocolInfo>();
        File protocol_directory = new File(this.getGuacamoleHome(), "protocols");
        if (protocol_directory.isDirectory()) {
            File[] files = protocol_directory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return string.endsWith(".json");
                }
            });
            if (files == null) {
                logger.error("Unable to read contents of \"{}\".", (Object)protocol_directory.getAbsolutePath());
                files = new File[]{};
            }
            File[] fileArray = files;
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                File file = fileArray[i];
                try {
                    FileInputStream stream = new FileInputStream(file);
                    ProtocolInfo protocol = this.readProtocol(stream);
                    stream.close();
                    protocols.put(protocol.getName(), protocol);
                    continue;
                }
                catch (IOException e) {
                    logger.error("Unable to read connection parameter information from \"{}\": {}", (Object)file.getAbsolutePath(), (Object)e.getMessage());
                    logger.debug("Error reading protocol JSON.", (Throwable)e);
                }
            }
        }
        for (String protocol : KNOWN_PROTOCOLS) {
            InputStream stream;
            if (protocols.containsKey(protocol) || (stream = LocalEnvironment.class.getResourceAsStream("/org/apache/guacamole/protocols/" + protocol + ".json")) == null) continue;
            try {
                protocols.put(protocol, this.readProtocol(stream));
            }
            catch (IOException e) {
                logger.error("Unable to read pre-defined connection parameter information for protocol \"{}\": {}", (Object)protocol, (Object)e.getMessage());
                logger.debug("Error reading pre-defined protocol JSON.", (Throwable)e);
            }
        }
        return protocols;
    }

    @Override
    public File getGuacamoleHome() {
        return this.guacHome;
    }

    private String getPropertyValue(String name) throws GuacamoleException {
        for (GuacamoleProperties properties : availableProperties) {
            String value = properties.getProperty(name);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public <Type> Type getProperty(GuacamoleProperty<Type> property) throws GuacamoleException {
        return property.parseValue(this.getPropertyValue(property.getName()));
    }

    @Override
    public <Type> Type getProperty(GuacamoleProperty<Type> property, Type defaultValue) throws GuacamoleException {
        Type value = this.getProperty(property);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public <Type> Type getRequiredProperty(GuacamoleProperty<Type> property) throws GuacamoleException {
        Type value = this.getProperty(property);
        if (value == null) {
            throw new GuacamoleServerException("Property " + property.getName() + " is required.");
        }
        return value;
    }

    @Override
    public Map<String, ProtocolInfo> getProtocols() {
        return this.availableProtocols;
    }

    @Override
    public ProtocolInfo getProtocol(String name) {
        return this.availableProtocols.get(name);
    }

    @Override
    public GuacamoleProxyConfiguration getDefaultGuacamoleProxyConfiguration() throws GuacamoleException {
        return new GuacamoleProxyConfiguration(this.getProperty(Environment.GUACD_HOSTNAME, DEFAULT_GUACD_HOSTNAME), (int)this.getProperty(Environment.GUACD_PORT, 4822), this.getProperty(Environment.GUACD_SSL, false));
    }

    @Override
    public void addGuacamoleProperties(GuacamoleProperties properties) {
        availableProperties.add(properties);
    }
}

