/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.net.auth;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.net.GuacamoleTunnel;
import org.apache.guacamole.net.auth.ConnectionGroup;
import org.apache.guacamole.protocol.GuacamoleClientInformation;

public class DelegatingConnectionGroup
implements ConnectionGroup {
    private final ConnectionGroup connectionGroup;
    private final ThreadLocal<Map<String, String>> currentTokens = new ThreadLocal<Map<String, String>>(){

        @Override
        protected Map<String, String> initialValue() {
            return Collections.emptyMap();
        }
    };

    public DelegatingConnectionGroup(ConnectionGroup connectionGroup) {
        this.connectionGroup = connectionGroup;
    }

    protected ConnectionGroup getDelegateConnectionGroup() {
        return this.connectionGroup;
    }

    @Override
    public String getIdentifier() {
        return this.connectionGroup.getIdentifier();
    }

    @Override
    public void setIdentifier(String identifier) {
        this.connectionGroup.setIdentifier(identifier);
    }

    @Override
    public String getName() {
        return this.connectionGroup.getName();
    }

    @Override
    public void setName(String name) {
        this.connectionGroup.setName(name);
    }

    @Override
    public String getParentIdentifier() {
        return this.connectionGroup.getParentIdentifier();
    }

    @Override
    public void setParentIdentifier(String parentIdentifier) {
        this.connectionGroup.setParentIdentifier(parentIdentifier);
    }

    @Override
    public void setType(ConnectionGroup.Type type) {
        this.connectionGroup.setType(type);
    }

    @Override
    public ConnectionGroup.Type getType() {
        return this.connectionGroup.getType();
    }

    @Override
    public Set<String> getConnectionIdentifiers() throws GuacamoleException {
        return this.connectionGroup.getConnectionIdentifiers();
    }

    @Override
    public Set<String> getConnectionGroupIdentifiers() throws GuacamoleException {
        return this.connectionGroup.getConnectionGroupIdentifiers();
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.connectionGroup.getAttributes();
    }

    @Override
    public void setAttributes(Map<String, String> attributes) {
        this.connectionGroup.setAttributes(attributes);
    }

    @Override
    @Deprecated
    public GuacamoleTunnel connect(GuacamoleClientInformation info) throws GuacamoleException {
        return this.connectionGroup.connect(info, this.currentTokens.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GuacamoleTunnel connect(GuacamoleClientInformation info, Map<String, String> tokens) throws GuacamoleException {
        try {
            this.currentTokens.set(tokens);
            GuacamoleTunnel guacamoleTunnel = this.connect(info);
            return guacamoleTunnel;
        }
        finally {
            this.currentTokens.remove();
        }
    }

    @Override
    public int getActiveConnections() {
        return this.connectionGroup.getActiveConnections();
    }
}

